/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.custom.edit.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.component.custom.edit.helpers.ComponentLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.component.custom.edit.helpers.ConnectorHelper;
import org.eclipse.papyrus.uml.diagram.component.custom.edit.helpers.MultiDependencyHelper;
import org.eclipse.papyrus.uml.diagram.component.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.component.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class CustomDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)ComponentLinkMappingHelper.getInstance());
    }

    protected Set<String> getDroppableElementVisualId() {
        HashSet<String> droppableElementsVisualId = new HashSet<String>();
        droppableElementsVisualId.add("Model_Shape_CN");
        droppableElementsVisualId.add("Package_Shape_CN");
        droppableElementsVisualId.add("Component_PackagedElementShape_CCN");
        droppableElementsVisualId.add("Component_PackagedElementShape_CN");
        droppableElementsVisualId.add("Interface_Shape_CN");
        droppableElementsVisualId.add("Comment_Shape_CN");
        droppableElementsVisualId.add("Constraint_Shape_CN");
        droppableElementsVisualId.add("Dependency_Shape");
        droppableElementsVisualId.add("Model_Shape");
        droppableElementsVisualId.add("Package_Shape");
        droppableElementsVisualId.add("Component_PackagedElementShape");
        droppableElementsVisualId.add("Interface_Shape");
        droppableElementsVisualId.add("Comment_Shape");
        droppableElementsVisualId.add("Constraint_Shape");
        droppableElementsVisualId.add("Port_Shape");
        droppableElementsVisualId.add("Connector_Edge");
        return droppableElementsVisualId;
    }

    public IElementType getUMLElementType(String elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public String getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public String getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        block59: {
            block57: {
                if (linkVISUALID == null) break block57;
                switch (linkVISUALID) {
                    case "Abstraction_Edge": {
                        return this.dropAbstraction(dropRequest, semanticElement, linkVISUALID);
                    }
                    case "Substitution_Edge": {
                        return this.dropAsNormalBinaryLink(dropRequest, semanticElement, linkVISUALID);
                    }
                    case "InterfaceRealization_Edge": {
                        return this.dropAsNormalBinaryLink(dropRequest, semanticElement, linkVISUALID);
                    }
                    case "Usage_Edge": {
                        return this.dropAsNormalBinaryLink(dropRequest, semanticElement, linkVISUALID);
                    }
                    case "Connector_Edge": {
                        return this.dropConnector(dropRequest, semanticElement, linkVISUALID);
                    }
                }
            }
            if (nodeVISUALID == null) break block59;
            switch (nodeVISUALID) {
                case "Package_Shape_CN": 
                case "Interface_Shape_CN": 
                case "Component_PackagedElementShape_CN": 
                case "Model_Shape_CN": {
                    return this.dropChildNode(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
                }
                case "Dependency_Shape": {
                    return this.dropDependencyNode(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Model_Shape": 
                case "Package_Shape": 
                case "Component_PackagedElementShape": 
                case "Interface_Shape": {
                    return this.dropTopLevelNode(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
                }
                case "Port_Shape": {
                    return this.dropAffixedNode(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Comment_Shape": 
                case "Comment_Shape_CN": {
                    return this.dropComment(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Constraint_Shape": 
                case "Constraint_Shape_CN": {
                    return this.dropConstraint(dropRequest, semanticElement, nodeVISUALID);
                }
            }
        }
        return super.getSpecificDropCommand(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
    }

    protected Command dropConnector(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> connectorEnds = ComponentLinkMappingHelper.getInstance().getSource(semanticLink);
        if (connectorEnds != null && connectorEnds.size() == 2) {
            ConnectorHelper helper = new ConnectorHelper(this.getEditingDomain());
            return new ICommandProxy((ICommand)helper.dropConnector((Connector)semanticLink, linkVISUALID, this.getViewer(), this.getHost(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView()));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropAsNormalBinaryLink(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection sources = this.linkmappingHelper.getSource(semanticLink);
        Collection targets = this.linkmappingHelper.getTarget(semanticLink);
        if (sources.size() == 0 || targets.size() == 0) {
            return UnexecutableCommand.INSTANCE;
        }
        Element source = (Element)sources.toArray()[0];
        Element target = (Element)targets.toArray()[0];
        CompositeCommand cc = new CompositeCommand("");
        this.dropBinaryLink(cc, source, target, linkVISUALID, dropRequest.getLocation(), semanticLink);
        return new ICommandProxy((ICommand)cc);
    }

    private Command dropChildNode(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof Package) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropDependencyNode(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID) {
        Collection<?> sources = ComponentLinkMappingHelper.getInstance().getSource(semanticElement);
        Collection<?> targets = ComponentLinkMappingHelper.getInstance().getTarget(semanticElement);
        if (sources.size() == 1 && targets.size() == 1) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("Drop Dependency"), source, target, "Dependency_Edge", dropRequest.getLocation(), semanticElement));
        }
        if (sources.size() > 1 || targets.size() > 1) {
            MultiDependencyHelper dependencyHelper = new MultiDependencyHelper(this.getEditingDomain());
            return dependencyHelper.dropMutliDependency((Dependency)semanticElement, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropComment(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if ("Comment_Shape".equals(nodeVISUALID)) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_Shape, (IHintedType)UMLElementTypes.Comment_AnnotatedElementEdge);
        }
        if ("Comment_Shape_CN".equals(nodeVISUALID)) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_Shape_CN, (IHintedType)UMLElementTypes.Comment_AnnotatedElementEdge);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropConstraint(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if ("Constraint_Shape".equals(nodeVISUALID)) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_Shape, (IHintedType)UMLElementTypes.Constraint_ConstrainedElementEdge);
        }
        if ("Constraint_Shape_CN".equals(nodeVISUALID)) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_Shape_CN, (IHintedType)UMLElementTypes.Constraint_ConstrainedElementEdge);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropDependency(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> sourceEnds = ComponentLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = ComponentLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = (Element)sourceEnds.toArray()[0];
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Dependency"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropAbstraction(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> sourceEnds = ComponentLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = ComponentLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = (Element)sourceEnds.toArray()[0];
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop Abstraction"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropRoleBinding(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> sourceEnds = ComponentLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = ComponentLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = semanticLink.getOwner();
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop RoleBinding"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropProperty(DropObjectsRequest dropRequest, Property droppedElement, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        Point location = dropRequest.getLocation().getCopy();
        if (!(droppedElement instanceof Port)) {
            Type type;
            if (graphicalParentObject instanceof Classifier && ((Classifier)graphicalParentObject).getAllAttributes().contains((Object)droppedElement)) {
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement));
            }
            if (graphicalParentObject instanceof ConnectableElement && (type = ((ConnectableElement)graphicalParentObject).getType()) != null && type instanceof Classifier && ((Classifier)type).getAllAttributes().contains((Object)droppedElement)) {
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement));
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropTopLevelNode(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof Package) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getDragCommand(ChangeBoundsRequest request) {
        Boolean isSpecificDrag = false;
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EObject droppedObject = null;
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof GraphicalEditPart) {
                droppedObject = ((GraphicalEditPart)droppedEditPart).resolveSemanticElement();
            }
            isSpecificDrag = this.isSpecificDropActionExpected((GraphicalEditPart)this.getHost(), droppedObject);
        }
        if (isSpecificDrag.booleanValue()) {
            return null;
        }
        return super.getDragCommand(request);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        Boolean isSpecificDrop = false;
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EObject droppedObject = null;
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof GraphicalEditPart) {
                droppedObject = ((GraphicalEditPart)droppedEditPart).resolveSemanticElement();
            }
            isSpecificDrop = this.isSpecificDropActionExpected((GraphicalEditPart)this.getHost(), droppedObject);
        }
        if (isSpecificDrop.booleanValue()) {
            return this.getDropObjectsCommand(this.castToDropObjectsRequest(request));
        }
        return super.getDropCommand(request);
    }

    protected boolean isSpecificDropActionExpected(GraphicalEditPart graphicalParent, EObject droppedObject) {
        boolean isSpecificDropActionExpected = false;
        EObject graphicalParentObject = graphicalParent.resolveSemanticElement();
        if (graphicalParentObject != null) {
            if (graphicalParentObject instanceof Collaboration) {
                if (droppedObject instanceof Collaboration || droppedObject instanceof Class) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof StructuredClassifier) {
                if (droppedObject instanceof Collaboration || droppedObject instanceof Class) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof TypedElement) {
                if (droppedObject instanceof Type) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof CollaborationUse && droppedObject instanceof Collaboration) {
                isSpecificDropActionExpected = true;
            }
        }
        return isSpecificDropActionExpected;
    }
}

