/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.editor.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.editor.Activator;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class TraverseTabHandler
extends AbstractHandler {
    private final boolean isPrevious;

    public TraverseTabHandler() {
        this.isPrevious = false;
    }

    public TraverseTabHandler(boolean isPrevious) {
        this.isPrevious = isPrevious;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePart = activeWorkbenchWindow.getActivePage().getActivePart()) instanceof PapyrusMultiDiagramEditor) {
            PapyrusMultiDiagramEditor papyrusEditor = (PapyrusMultiDiagramEditor)activePart;
            try {
                IPage nextPage = null;
                nextPage = this.isPrevious ? papyrusEditor.getISashWindowsContainer().getPreviousPage() : papyrusEditor.getISashWindowsContainer().getNextPage();
                papyrusEditor.getISashWindowsContainer().selectPage(nextPage);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }
}

