/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.spi.net4j;

import java.text.MessageFormat;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.concurrent.ExecutorWorkSerializer;
import org.eclipse.net4j.util.concurrent.IExecutorServiceProvider;
import org.eclipse.net4j.util.concurrent.IWorkSerializer;
import org.eclipse.net4j.util.concurrent.QueueWorkerWorkSerializer;
import org.eclipse.net4j.util.concurrent.RunnableWithName;
import org.eclipse.net4j.util.concurrent.SynchronousWorkSerializer;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.InternalChannel;
import org.eclipse.spi.net4j.InternalChannelMultiplexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel
extends Lifecycle
implements InternalChannel,
IExecutorServiceProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_CHANNEL, Channel.class);
    private String userID;
    private InternalChannelMultiplexer channelMultiplexer;
    private short id = Short.MIN_VALUE;
    private ExecutorService receiveExecutor;
    private IBufferHandler receiveHandler;
    private IWorkSerializer receiveSerializer;
    private transient Queue<IBuffer> sendQueue;
    private transient long sentBuffers;
    private transient long receivedBuffers;

    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public ILocationAware.Location getLocation() {
        return this.channelMultiplexer.getLocation();
    }

    @Override
    public boolean isClient() {
        return this.channelMultiplexer.isClient();
    }

    @Override
    public boolean isServer() {
        return this.channelMultiplexer.isServer();
    }

    @Override
    public IChannelMultiplexer getMultiplexer() {
        return this.channelMultiplexer;
    }

    @Override
    public void setMultiplexer(IChannelMultiplexer channelMultiplexer) {
        this.channelMultiplexer = (InternalChannelMultiplexer)channelMultiplexer;
    }

    @Override
    public short getID() {
        return this.id;
    }

    @Override
    public void setID(short id) {
        this.checkArg(id != Short.MIN_VALUE, "id == IBuffer.NO_CHANNEL");
        this.id = id;
    }

    public ExecutorService getExecutorService() {
        return this.receiveExecutor;
    }

    @Override
    public ExecutorService getReceiveExecutor() {
        return this.receiveExecutor;
    }

    @Override
    public void setReceiveExecutor(ExecutorService receiveExecutor) {
        this.receiveExecutor = receiveExecutor;
    }

    @Override
    public IBufferHandler getReceiveHandler() {
        return this.receiveHandler;
    }

    @Override
    public void setReceiveHandler(IBufferHandler receiveHandler) {
        this.receiveHandler = receiveHandler;
    }

    @Override
    public long getSentBuffers() {
        return this.sentBuffers;
    }

    @Override
    public long getReceivedBuffers() {
        return this.receivedBuffers;
    }

    @Override
    public Queue<IBuffer> getSendQueue() {
        return this.sendQueue;
    }

    @Override
    public void sendBuffer(IBuffer buffer) {
        this.handleBuffer(buffer);
    }

    @Override
    public void handleBuffer(IBuffer buffer) {
        BufferState state = buffer.getState();
        if (state != BufferState.PUTTING) {
            OM.LOG.warn("Ignoring buffer in state == " + (Object)((Object)state) + ": " + this);
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Handling buffer: {0} --> {1}", new Object[]{buffer, this});
        }
        if (this.sendQueue == null) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Ignoring buffer because sendQueue == null: " + this);
            }
            buffer.release();
        } else {
            this.sendQueue.add(buffer);
            ++this.sentBuffers;
            this.channelMultiplexer.multiplexChannel(this);
        }
    }

    @Override
    public void handleBufferFromMultiplexer(IBuffer buffer) {
        if (this.receiveHandler != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Handling buffer from multiplexer: {0} --> {1}", new Object[]{buffer, this});
            }
            ++this.receivedBuffers;
            ReceiverWork receiverWork = this.createReceiverWork(buffer);
            this.receiveSerializer.addWork((Runnable)((Object)receiverWork));
        } else {
            buffer.release();
        }
    }

    protected ReceiverWork createReceiverWork(IBuffer buffer) {
        return new ReceiverWork(buffer);
    }

    @Override
    public short getBufferCapacity() {
        return this.channelMultiplexer.getBufferCapacity();
    }

    @Override
    public IBuffer provideBuffer() {
        return this.channelMultiplexer.provideBuffer();
    }

    @Override
    public void retainBuffer(IBuffer buffer) {
        this.channelMultiplexer.retainBuffer(buffer);
    }

    public String toString() {
        if (this.receiveHandler instanceof IProtocol) {
            IProtocol protocol = (IProtocol)this.receiveHandler;
            return MessageFormat.format("Channel[{0}, {1}, {2}]", new Object[]{this.id, this.getLocation(), protocol.getType()});
        }
        return MessageFormat.format("Channel[{0}, {1}]", new Object[]{this.id, this.getLocation()});
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.id != Short.MIN_VALUE, "channelID == NO_CHANNEL");
        this.checkState(this.channelMultiplexer, "channelMultiplexer");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.sendQueue = new SendQueue();
        if (this.receiveExecutor != null) {
            this.receiveSerializer = new ReceiveSerializer2(this.receiveExecutor);
            LifecycleUtil.activate((Object)this.receiveSerializer);
        } else {
            this.receiveSerializer = new SynchronousWorkSerializer();
        }
    }

    protected void doDeactivate() throws Exception {
        this.unregisterFromMultiplexer();
        if (this.receiveSerializer != null) {
            this.receiveSerializer.dispose();
            this.receiveSerializer = null;
        }
        if (this.sendQueue != null) {
            this.sendQueue.clear();
            this.sendQueue = null;
        }
        super.doDeactivate();
    }

    protected void unregisterFromMultiplexer() {
        this.channelMultiplexer.closeChannel(this);
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    @Deprecated
    protected class ReceiveSerializer
    extends QueueWorkerWorkSerializer {
        protected ReceiveSerializer() {
        }

        protected String getThreadName() {
            return "Net4jReceiveSerializer-" + Channel.this;
        }

        protected void noWork(Worker.WorkContext context) {
            if (Channel.this.isClosed()) {
                context.terminate();
            }
        }
    }

    private class ReceiveSerializer2
    extends ExecutorWorkSerializer {
        public ReceiveSerializer2(Executor executor) {
            super(executor);
        }

        protected void noWork() {
            if (Channel.this.isClosed()) {
                this.dispose();
            }
        }
    }

    protected class ReceiverWork
    extends RunnableWithName {
        private final IBuffer buffer;

        public ReceiverWork(IBuffer buffer) {
            this.buffer = buffer;
        }

        public String getName() {
            return "Net4jReceiveSerializer-" + Channel.this;
        }

        protected void doRun() {
            IBufferHandler receiveHandler = Channel.this.getReceiveHandler();
            if (receiveHandler != null) {
                receiveHandler.handleBuffer(this.buffer);
            } else {
                this.buffer.release();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SendQueue
    extends ConcurrentLinkedQueue<IBuffer> {
        private static final long serialVersionUID = 1L;
        private AtomicInteger size = new AtomicInteger();

        protected SendQueue() {
        }

        @Override
        public boolean add(IBuffer o) {
            super.add(o);
            this.added();
            return true;
        }

        @Override
        public boolean offer(IBuffer o) {
            super.offer(o);
            this.added();
            return true;
        }

        @Override
        public IBuffer poll() {
            IBuffer result = (IBuffer)super.poll();
            if (result != null) {
                this.removed();
            }
            return result;
        }

        @Override
        public IBuffer remove() {
            IBuffer result = (IBuffer)super.remove();
            if (result != null) {
                this.removed();
            }
            return result;
        }

        @Override
        public boolean remove(Object o) {
            boolean result = super.remove(o);
            if (result) {
                this.removed();
            }
            return result;
        }

        private void added() {
            int queueSize = this.size.incrementAndGet();
            IListener[] listeners = Channel.this.getListeners();
            if (listeners != null) {
                Channel.this.fireEvent(new SendQueueEventImpl(InternalChannel.SendQueueEvent.Type.ENQUEUED, queueSize), listeners);
            }
        }

        private void removed() {
            int queueSize = this.size.decrementAndGet();
            IListener[] listeners = Channel.this.getListeners();
            if (listeners != null) {
                Channel.this.fireEvent(new SendQueueEventImpl(InternalChannel.SendQueueEvent.Type.DEQUEUED, queueSize), listeners);
            }
        }
    }

    private final class SendQueueEventImpl
    extends Event
    implements InternalChannel.SendQueueEvent {
        private static final long serialVersionUID = 1L;
        private InternalChannel.SendQueueEvent.Type type;
        private final int queueSize;

        private SendQueueEventImpl(InternalChannel.SendQueueEvent.Type type, int queueSize) {
            super((INotifier)Channel.this);
            this.type = type;
            this.queueSize = queueSize;
        }

        public InternalChannel getSource() {
            return (InternalChannel)super.getSource();
        }

        public InternalChannel.SendQueueEvent.Type getType() {
            return this.type;
        }

        public int getQueueSize() {
            return this.queueSize;
        }
    }
}

