/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.ModelManager;

public abstract class LazyModelManager
implements ModelManager {
    private final @NonNull Map<@NonNull Type, @NonNull Set<@NonNull EObject>> modelManager = new HashMap<Type, Set<EObject>>();
    private final @NonNull Collection<@NonNull EObject> roots;

    public LazyModelManager(EObject context) {
        context = EcoreUtil.getRootContainer((EObject)context);
        Resource eResource = context.eResource();
        this.roots = eResource != null ? eResource.getContents() : Collections.singleton(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Set<@NonNull ? extends Object> get(@NonNull Class type) {
        Set<@NonNull EObject> result = this.modelManager.get(type);
        if (result == null) {
            Map<Type, Set<EObject>> map = this.modelManager;
            synchronized (map) {
                result = this.modelManager.get(type);
                if (result == null) {
                    result = new HashSet<EObject>();
                    this.modelManager.put(type, result);
                    TreeIterator iter = EcoreUtil.getAllContents(this.roots);
                    while (iter.hasNext()) {
                        EObject next = (EObject)iter.next();
                        if (next == null || !this.isInstance(type, next)) continue;
                        result.add(next);
                    }
                }
            }
        }
        return result;
    }

    protected abstract boolean isInstance(@NonNull Type var1, @NonNull EObject var2);

    public String toString() {
        return this.modelManager.toString();
    }
}

