/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.diagram.common.provider;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.provider.IGraphicalTypeRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.AbstractVisualTypeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.IVisualTypeProvider;
import org.eclipse.papyrus.sysml.diagram.common.Activator;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;

public class SysMLVisualTypeProvider
extends AbstractVisualTypeProvider {
    private final IGraphicalTypeRegistry types;
    private final IVisualTypeProvider uml;

    protected SysMLVisualTypeProvider(IGraphicalTypeRegistry types, IVisualTypeProvider uml) {
        this.types = types;
        this.uml = uml;
    }

    public IElementType getElementType(Diagram diagram, String viewType) {
        IElementType result = this.getCustomElementType(viewType);
        if (result == null && viewType != null) {
            Field[] fieldArray = SysMLElementTypes.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (IElementType.class.isAssignableFrom(field.getType()) && Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers())) {
                    try {
                        IElementType candidate = (IElementType)field.get(null);
                        if (candidate instanceof IHintedType && viewType.equals(((IHintedType)candidate).getSemanticHint())) {
                            result = candidate;
                            break;
                        }
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
                ++n2;
            }
            if (result == null) {
                result = this.uml.getElementType(diagram, viewType);
            }
        }
        return result;
    }

    protected IElementType getCustomElementType(String viewType) {
        return null;
    }

    public String getNodeType(View parentView, EObject element) {
        String result = this.types.getNodeGraphicalType(element, parentView.getType());
        if (result == null) {
            result = this.uml.getNodeType(parentView, element);
        }
        return result;
    }

    public String getLinkType(Diagram diagram, EObject element) {
        String result = this.types.getEdgeGraphicalType(element);
        if (result == null) {
            result = this.uml.getLinkType(diagram, element);
        }
        return result;
    }
}

