/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.DefaultDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConstraint;
import org.eclipse.papyrus.extensionpoints.editors.definition.DirectEditorExtensionPoint;
import org.eclipse.papyrus.extensionpoints.editors.definition.IDirectEditorExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectEditorsUtil {
    private static final int UNKNOWN_PRIORITY = 100;

    @Deprecated
    public static IDirectEditorConfiguration findEditorConfiguration(String language, String objectToEdit) {
        IDirectEditorExtensionPoint[] extensionPoints;
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IDirectEditorExtensionPoint directEditorExtensionPoint = iDirectEditorExtensionPointArray[n2];
            String lang = directEditorExtensionPoint.getLanguage();
            String oToEdit = directEditorExtensionPoint.getObjectToEdit();
            if (lang.equals(language) && oToEdit.equals(objectToEdit)) {
                return directEditorExtensionPoint.getDirectEditorConfiguration();
            }
            ++n2;
        }
        return new DefaultDirectEditorConfiguration();
    }

    public static IDirectEditorConfiguration findEditorConfiguration(String language, Object semanticObjectToEdit, Object selectedElement) {
        IDirectEditorExtensionPoint[] extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        IDirectEditorConfiguration editorConfiguration = new DefaultDirectEditorConfiguration();
        int configurationPriority = 100;
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = extensionPoints;
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IDirectEditorConstraint constraint;
            IDirectEditorExtensionPoint directEditorExtensionPoint = iDirectEditorExtensionPointArray[n2];
            String lang = directEditorExtensionPoint.getLanguage();
            Class<? extends EObject> classToEdit = directEditorExtensionPoint.getObjectClassToEdit();
            if (lang.equals(language) && classToEdit.isInstance(semanticObjectToEdit) && ((constraint = directEditorExtensionPoint.getAdditionalConstraint()) == null || constraint.appliesTo(selectedElement)) && directEditorExtensionPoint.getPriority() < configurationPriority) {
                editorConfiguration = directEditorExtensionPoint.getDirectEditorConfiguration();
                configurationPriority = directEditorExtensionPoint.getPriority();
            }
            ++n2;
        }
        return editorConfiguration;
    }

    @Deprecated
    public static boolean hasSpecificEditorConfiguration(String language, String objectToEdit) {
        IDirectEditorExtensionPoint[] extensionPoints;
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IDirectEditorExtensionPoint directEditorExtensionPoint = iDirectEditorExtensionPointArray[n2];
            String lang = directEditorExtensionPoint.getLanguage();
            String oToEdit = directEditorExtensionPoint.getObjectToEdit();
            if (lang.equals(language) && oToEdit.equals(objectToEdit)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasSpecificEditorConfiguration(String language, Object semanticObjectToEdit, Object selectedElement) {
        IDirectEditorExtensionPoint[] extensionPoints;
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IDirectEditorConstraint constraint;
            IDirectEditorExtensionPoint directEditorExtensionPoint = iDirectEditorExtensionPointArray[n2];
            String lang = directEditorExtensionPoint.getLanguage();
            Class<? extends EObject> classToEdit = directEditorExtensionPoint.getObjectClassToEdit();
            if (lang.equals(language) && classToEdit.isInstance(semanticObjectToEdit) && ((constraint = directEditorExtensionPoint.getAdditionalConstraint()) == null || constraint.appliesTo(selectedElement))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Deprecated
    public static boolean hasSpecificEditorConfiguration(String objectToEdit) {
        IDirectEditorExtensionPoint[] extensionPoints;
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IDirectEditorExtensionPoint directEditorExtensionPoint = iDirectEditorExtensionPointArray[n2];
            String oToEdit = directEditorExtensionPoint.getObjectToEdit();
            if (oToEdit.equals(objectToEdit)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasSpecificEditorConfiguration(Object semanticObjectToEdit, Object selectedElement) {
        IDirectEditorExtensionPoint[] extensionPoints;
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IDirectEditorConstraint constraint;
            IDirectEditorExtensionPoint directEditorExtensionPoint = iDirectEditorExtensionPointArray[n2];
            Class<? extends EObject> classToEdit = directEditorExtensionPoint.getObjectClassToEdit();
            if (classToEdit.isInstance(semanticObjectToEdit) && ((constraint = directEditorExtensionPoint.getAdditionalConstraint()) == null || constraint.appliesTo(selectedElement))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IDirectEditorExtensionPoint getDefautDirectEditorConfiguration(Object semanticObjectToEdit, Object selectedObject) {
        String language = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + semanticObjectToEdit.getClass().asSubclass(EObject.class));
        if (language == null || "Simple Direct Editor".equals(language)) {
            return null;
        }
        IDirectEditorExtensionPoint currentConfiguration = null;
        int currentPriority = 100;
        Collection<IDirectEditorExtensionPoint> configs = DirectEditorsUtil.getDirectEditorConfigurations(semanticObjectToEdit, selectedObject);
        for (IDirectEditorExtensionPoint extensionPoint : configs) {
            if (!language.equals(extensionPoint.getLanguage()) || extensionPoint.getPriority() >= currentPriority) continue;
            currentConfiguration = extensionPoint;
            currentPriority = extensionPoint.getPriority();
        }
        return currentConfiguration;
    }

    public static Collection<IDirectEditorExtensionPoint> getDirectEditorConfigurations(Object semanticObjectToEdit, Object selectedObject) {
        ArrayList<IDirectEditorExtensionPoint> elementConfigurations = new ArrayList<IDirectEditorExtensionPoint>();
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = iDirectEditorExtensionPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDirectEditorConstraint constraint;
            IDirectEditorExtensionPoint configuration = iDirectEditorExtensionPointArray[n2];
            if (configuration.getObjectClassToEdit() != null && configuration.getObjectClassToEdit().isInstance(semanticObjectToEdit) && ((constraint = configuration.getAdditionalConstraint()) == null || constraint.appliesTo(selectedObject))) {
                elementConfigurations.add(configuration);
            }
            ++n2;
        }
        return elementConfigurations;
    }

    public static IDirectEditorConfiguration findEditorConfigurationWithPriority(String language, String objectToEdit) {
        IDirectEditorExtensionPoint[] extensionPoints;
        IDirectEditorConfiguration result = null;
        int currentPrority = 100;
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IDirectEditorExtensionPoint directEditorExtensionPoint = iDirectEditorExtensionPointArray[n2];
            String lang = directEditorExtensionPoint.getLanguage();
            String oToEdit = directEditorExtensionPoint.getObjectToEdit();
            if (lang.equals(language) && oToEdit.equals(objectToEdit)) {
                int directEditorExtensionPointPriority;
                int n3 = directEditorExtensionPointPriority = directEditorExtensionPoint.getPriority() != null ? directEditorExtensionPoint.getPriority() : 100;
                if (result == null || directEditorExtensionPointPriority < currentPrority) {
                    result = directEditorExtensionPoint.getDirectEditorConfiguration();
                    currentPrority = directEditorExtensionPointPriority;
                }
            }
            ++n2;
        }
        return result != null ? result : new DefaultDirectEditorConfiguration();
    }

    public static List<String> getLanguages(String objectToEdit) {
        IDirectEditorExtensionPoint[] extensionPoints;
        ArrayList<String> languages = new ArrayList<String>();
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            String lang;
            IDirectEditorExtensionPoint directEditorExtensionPoint = iDirectEditorExtensionPointArray[n2];
            if ((objectToEdit == null || directEditorExtensionPoint.getObjectToEdit().equals(objectToEdit)) && !languages.contains(lang = directEditorExtensionPoint.getLanguage())) {
                languages.add(lang);
            }
            ++n2;
        }
        return languages;
    }
}

