/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards;

import com.google.common.base.Strings;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards.IGeneratorWizardPage;
import org.eclipse.uml2.uml.Profile;

public class GeneratorWizardModel {
    private final IWizard owner;
    private final Profile profile;
    private final IDialogSettings settings;
    private String identifier;
    private String selectedElementTypeSet;
    private IPath containerPath;
    private String fileName;
    private boolean suppressSemanticSuperElementTypes;

    public GeneratorWizardModel(IWizard owner, Profile profile, IDialogSettings settings) {
        this.owner = owner;
        this.profile = profile;
        this.settings = settings;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public IDialogSettings getDialogSettings() {
        return this.settings;
    }

    private WizardPage currentPage() {
        WizardPage result = (WizardPage)this.owner.getContainer().getCurrentPage();
        if (result == null) {
            result = (WizardPage)this.owner.getStartingPage();
        }
        return result;
    }

    public void setErrorMessage(String message) {
        this.currentPage().setErrorMessage(message);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getSelectedElementTypeSet() {
        return this.selectedElementTypeSet;
    }

    public void setSelectedElementTypeSet(String selectedElementTypeSet) {
        this.selectedElementTypeSet = selectedElementTypeSet;
    }

    public void setContainerPath(IPath containerPath) {
        this.containerPath = containerPath;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSuppressSemanticSuperElementTypes(boolean suppressSemanticSuperElementTypes) {
        this.suppressSemanticSuperElementTypes = suppressSemanticSuperElementTypes;
    }

    public boolean isSuppressSemanticSuperElementTypes() {
        return this.suppressSemanticSuperElementTypes;
    }

    public URI getOutputModelURI() {
        return URI.createPlatformResourceURI((String)this.containerPath.append(this.fileName).toString(), (boolean)true);
    }

    public IFile getOutputModelFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.containerPath.append(this.fileName));
    }

    public void validatePage() {
        WizardPage current = this.currentPage();
        if (current instanceof IGeneratorWizardPage) {
            current.setPageComplete(((IGeneratorWizardPage)current).validatePage());
        }
    }

    public boolean validate() {
        boolean result = true;
        this.setErrorMessage(null);
        if (Strings.isNullOrEmpty((String)this.getIdentifier())) {
            this.setErrorMessage("An identifier is required.");
            result = false;
        } else if (this.getSelectedElementTypeSet() == null) {
            this.setErrorMessage("A base element type set must be selected.");
            result = false;
        }
        return result;
    }

    IStructuredSelection getDefaultContainerSelection() {
        IFile file = ResourceUtils.getFile((Resource)this.getProfile().eResource());
        return file == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)file.getParent());
    }

    String getDefaultFileName() {
        return GeneratorWizardModel.trimExtensions(EcoreUtil.getURI((EObject)this.profile).trimFragment()).lastSegment();
    }

    static URI trimExtensions(URI uri) {
        URI result = uri.trimFileExtension();
        while (!result.equals(uri)) {
            uri = result;
            result = result.trimFileExtension();
        }
        return result;
    }
}

