/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.compositeforview;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementContentProvider;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementLabelProvider;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementTreeViewerFilter;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel.AppearanceDecoratedTreeComposite;
import org.eclipse.papyrus.uml.properties.profile.ui.panels.AppliedStereotypePanel;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;

public class AppliedStereotypeDisplayComposite
extends AppearanceDecoratedTreeComposite
implements ISelectionChangedListener {
    private AppliedStereotypePanel parentPanel;
    protected CLabel label;

    public AppliedStereotypeDisplayComposite(AppliedStereotypePanel parent) {
        super(parent, 0, "Applied stereotypes", true);
        this.parentPanel = parent;
    }

    public AppliedStereotypeDisplayComposite(Composite parent) {
        super(parent, 0, "Applied stereotypes", true);
    }

    public Composite createContent(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createContent(parent, factory);
        this.createStereotypesTree();
        return this;
    }

    public Element getSelected() {
        return this.parentPanel.getSelected();
    }

    public Tree getTree() {
        return this.treeViewer.getTree();
    }

    public void setInput(StereotypedElementTreeObject element) {
        this.treeViewer.setInput((Object)element);
        if (Activator.getDefault().getPreferenceStore().getBoolean("StereotypesTree.expandAll")) {
            this.treeViewer.expandAll();
        }
    }

    public void refresh() {
        if (this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.refresh();
        }
    }

    private void createStereotypesTree() {
        this.treeViewer.setContentProvider((IContentProvider)new ProfileElementContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProfileElementLabelProvider());
        this.treeViewer.addFilter((ViewerFilter)new ProfileElementTreeViewerFilter());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.parentPanel != null) {
            if (event == null) {
                this.parentPanel.setSelectedProperty(null);
                return;
            }
            IStructuredSelection structSelection = (IStructuredSelection)event.getSelection();
            Object selection = structSelection.getFirstElement();
            if (selection instanceof AppliedStereotypePropertyTreeObject) {
                this.parentPanel.setSelectedProperty((AppliedStereotypePropertyTreeObject)selection);
            } else {
                this.parentPanel.setSelectedProperty(null);
            }
        }
    }
}

