/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.sync;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SemanticElementAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.VisualTypeService;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.AbstractNestedDiagramViewsSyncFeature;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.sync.SyncBucket;

public abstract class DiagramEdgesSyncFeature<M extends EObject, N extends EObject, T extends EditPart>
extends AbstractNestedDiagramViewsSyncFeature<M, N, T> {
    public DiagramEdgesSyncFeature(SyncBucket<M, T, Notification> bucket) {
        super(bucket, NotationPackage.Literals.DIAGRAM__PERSISTED_EDGES, NotationPackage.Literals.DIAGRAM__TRANSIENT_EDGES);
    }

    protected DiagramEditPart getEffectiveEditPart(EditPart parent) {
        return DiagramEditPartsUtil.getDiagramEditPart(parent);
    }

    @Override
    Iterable<? extends T> basicGetContents(T backend) {
        return this.getEffectiveEditPart((EditPart)backend).getConnections();
    }

    @Override
    protected EObject getNotifier(T backend) {
        Object result = backend instanceof ConnectionEditPart ? (View)backend.getModel() : super.getNotifier(backend);
        return result;
    }

    @Override
    protected CreateRequest getCreateRequest(IGraphicalEditPart parentPart, EObject element, Point atLocation) {
        String viewType;
        CreateConnectionViewRequest result = null;
        DiagramEditPart diagramPart = DiagramEditPartsUtil.getDiagramEditPart((EditPart)parentPart);
        Diagram diagram = diagramPart.getDiagramView();
        EObject source = this.getSourceElement(element);
        EObject target = this.getTargetElement(element);
        IGraphicalEditPart sourcePart = DiagramEditPartsUtil.getChildByEObject(source, (IGraphicalEditPart)diagramPart, false);
        IGraphicalEditPart targetPart = DiagramEditPartsUtil.getChildByEObject(target, (IGraphicalEditPart)diagramPart, false);
        if (sourcePart != null && targetPart != null && (viewType = VisualTypeService.getInstance().getLinkType(diagram, element)) != null) {
            IElementType elementType = VisualTypeService.getInstance().getElementType(diagram, viewType);
            SemanticElementAdapter elementAdapter = new SemanticElementAdapter(element, elementType);
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)elementAdapter, viewType, parentPart.getDiagramPreferencesHint());
            result = new CreateConnectionViewRequest(descriptor);
            result.setLocation(atLocation);
            result.setSourceEditPart((EditPart)sourcePart);
            result.setTargetEditPart((EditPart)targetPart);
        }
        return result;
    }

    protected abstract EObject getSourceElement(EObject var1);

    protected abstract EObject getTargetElement(EObject var1);

    @Override
    protected Command getCreateCommand(IGraphicalEditPart parentPart, CreateRequest request) {
        request.setType((Object)"connection start");
        ((CreateConnectionViewRequest)request).getSourceEditPart().getCommand((Request)request);
        request.setType((Object)"connection end");
        return ((CreateConnectionViewRequest)request).getTargetEditPart().getCommand((Request)request);
    }
}

