/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo;

import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.AssuranceassetPackage;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceprojectPackage;
import org.eclipse.opencert.apm.baseline.baseline.BaselinePackage;
import org.eclipse.opencert.evm.evidspec.evidence.EvidencePackage;
import org.eclipse.opencert.infra.general.general.GeneralPackage;
import org.eclipse.opencert.infra.properties.property.PropertyPackage;
import org.eclipse.opencert.pam.procspec.process.ProcessPackage;
import org.eclipse.opencert.pkm.refframework.refframework.RefframeworkPackage;
import org.eclipse.opencert.sam.arg.arg.ArgPackage;
import org.eclipse.opencert.storage.cdo.property.IOpencertClientConfigurationAdapter;
import org.eclipse.opencert.vocabulary.VocabularyPackage;

public class StandaloneCDOAccessor {
    private CDONet4jSessionConfiguration configuration;
    private static volatile StandaloneCDOAccessor standaloneCDOAccessor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandaloneCDOAccessor getStandaloneCDOAccessor(IOpencertClientConfigurationAdapter clientConfigurationAdapter) {
        if (standaloneCDOAccessor != null) return standaloneCDOAccessor;
        Class<StandaloneCDOAccessor> clazz = StandaloneCDOAccessor.class;
        synchronized (StandaloneCDOAccessor.class) {
            if (standaloneCDOAccessor != null) return standaloneCDOAccessor;
            standaloneCDOAccessor = new StandaloneCDOAccessor(clientConfigurationAdapter);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return standaloneCDOAccessor;
        }
    }

    private StandaloneCDOAccessor(IOpencertClientConfigurationAdapter clientConfigurationAdapter) {
        this.init(clientConfigurationAdapter);
    }

    private EPackage[] getEPackages() {
        return new EPackage[]{AssuranceassetPackage.eINSTANCE, AssuranceprojectPackage.eINSTANCE, BaselinePackage.eINSTANCE, EvidencePackage.eINSTANCE, MappingPackage.eINSTANCE, PropertyPackage.eINSTANCE, ProcessPackage.eINSTANCE, RefframeworkPackage.eINSTANCE, ArgPackage.eINSTANCE, VocabularyPackage.eINSTANCE, GeneralPackage.eINSTANCE};
    }

    public CDOSession openSession() {
        CDONet4jSession session = this.configuration.openNet4jSession();
        EPackage[] ePackageArray = this.getEPackages();
        int n = ePackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage ePackage = ePackageArray[n2];
            session.getPackageRegistry().putEPackage(ePackage);
            ++n2;
        }
        session.options().setGeneratedPackageEmulationEnabled(true);
        return session;
    }

    public static Resource getDefaultResource(CDOTransaction transaction) {
        return transaction.getOrCreateResource("/opencert.evidence");
    }

    private void init(IOpencertClientConfigurationAdapter clientConfigurationAdapter) {
        OMPlatform.INSTANCE.setDebugging(false);
        OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
        OMPlatform.INSTANCE.addTraceHandler((OMTraceHandler)PrintTraceHandler.CONSOLE);
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        TCPUtil.prepareContainer((IManagedContainer)container);
        CDONet4jUtil.prepareContainer((IManagedContainer)container);
        container.activate();
        ITCPConnector connector = TCPUtil.getConnector((IManagedContainer)container, (String)clientConfigurationAdapter.getCDOServerAddress());
        this.configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        this.configuration.setConnector((IConnector)connector);
        this.configuration.setRepositoryName("opencert");
    }
}

