/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.nattableconfiguration.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.papyrus.customization.nattableconfiguration.edition.FeatureFillingConfigurationDialog;
import org.eclipse.papyrus.customization.nattableconfiguration.edition.PasteEObjectConfigurationDialog;
import org.eclipse.papyrus.customization.nattableconfiguration.edition.TreeFillingConfigurationDialog;
import org.eclipse.papyrus.customization.nattableconfiguration.helper.TableConfigurationHelper;
import org.eclipse.papyrus.customization.nattableconfiguration.messages.Messages;
import org.eclipse.papyrus.customization.nattableconfiguration.pages.AbstractAxisConfigurationWizardPage;
import org.eclipse.papyrus.customization.nattableconfiguration.utils.NameSimplifier;
import org.eclipse.papyrus.customization.nattableconfiguration.utils.NattableConfigurationEditingSupport;
import org.eclipse.papyrus.infra.nattable.manager.axis.AxisManagerFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EOperationAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.provider.NattableaxisItemProviderAdapterFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.EStructuralFeatureValueFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.provider.NattableaxisconfigurationItemProviderAdapterFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class RowConfigurationWizardPage
extends AbstractAxisConfigurationWizardPage {
    private static final String E_CLASS = "eClass";
    protected static final List<String> requiredProposedAxisManagers = new ArrayList<String>();
    protected Button addAxisConfiguration;
    protected Button editAxisConfiguration;
    protected Button removeAxisConfiguration;

    static {
        requiredProposedAxisManagers.add("EMF Feature (org.eclipse.papyrus.infra.emf.nattable.feature.axis.manager)");
        requiredProposedAxisManagers.add("EMF Operation (org.eclipse.papyrus.infra.emf.nattable.operation.axis.manager)");
        requiredProposedAxisManagers.add("UML Element (org.eclipse.papyrus.uml.nattable.element.axis.manager)");
        requiredProposedAxisManagers.add("UML Feature (org.eclipse.papyrus.uml.nattable.feature.axis.manager)");
        requiredProposedAxisManagers.add("UML Operation (org.eclipse.papyrus.uml.nattable.operation.axis.manager)");
        requiredProposedAxisManagers.add("UML Tree Axis (org.eclipse.papyrus.infra.uml.nattable.class.tree.axis.manager)");
    }

    public RowConfigurationWizardPage(TableConfigurationHelper helper) {
        super(Messages.RowConfigurationWizardPage_pageName, helper);
    }

    @Override
    public TableHeaderAxisConfiguration getHeaderAxisConfiguration() {
        return this.helper.getTableConfiguration().getRowHeaderAxisConfiguration();
    }

    @Override
    public void createMoreComposite(Composite parent) {
        Group axisManagersGroup = new Group(parent, 0);
        axisManagersGroup.setText(Messages.RowConfigurationWizardPage_axisConfigurationsLabel);
        axisManagersGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        axisManagersGroup.setLayout((Layout)new GridLayout(2, false));
        final TreeViewer treeViewer = this.createAxisConfigurationTreeViewer((Composite)axisManagersGroup);
        Composite buttonsComposite = new Composite((Composite)axisManagersGroup, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        buttonsComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.addAxisConfiguration = new Button(buttonsComposite, 8);
        this.addAxisConfiguration.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.addAxisConfiguration.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        this.addAxisConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionAdapter selectionListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        EClass eClass = (EClass)event.widget.getData(RowConfigurationWizardPage.E_CLASS);
                        EObject instance = eClass.getEPackage().getEFactoryInstance().create(eClass);
                        if (instance instanceof IAxisConfiguration) {
                            (this).RowConfigurationWizardPage.this.headerAxisConfiguration.getOwnedAxisConfigurations().add((Object)((IAxisConfiguration)instance));
                            RowConfigurationWizardPage.this.editAxisConfiguration(instance);
                            treeViewer.setSelection((ISelection)new StructuredSelection((Object)instance));
                        }
                    }
                };
                Menu menu = new Menu((Control)RowConfigurationWizardPage.this.addAxisConfiguration);
                MenuItem treeFillingItem = new MenuItem(menu, 0);
                treeFillingItem.setText(Messages.RowConfigurationWizardPage_treeFillingConfigurationLabel);
                treeFillingItem.setData(RowConfigurationWizardPage.E_CLASS, (Object)NattableaxisconfigurationPackage.eINSTANCE.getEClassifier("TreeFillingConfiguration"));
                treeFillingItem.addSelectionListener((SelectionListener)selectionListener);
                MenuItem pasteEObjectItem = new MenuItem(menu, 0);
                pasteEObjectItem.setText(Messages.RowConfigurationWizardPage_pasteConfigurationLabel);
                pasteEObjectItem.setData(RowConfigurationWizardPage.E_CLASS, (Object)NattableaxisconfigurationPackage.eINSTANCE.getEClassifier("PasteEObjectConfiguration"));
                pasteEObjectItem.addSelectionListener((SelectionListener)selectionListener);
                MenuItem featureAxisItem = new MenuItem(menu, 0);
                featureAxisItem.setText(Messages.RowConfigurationWizardPage_featureAxisLabel);
                featureAxisItem.setData(RowConfigurationWizardPage.E_CLASS, (Object)NattableaxisconfigurationPackage.eINSTANCE.getEClassifier("FeatureAxisConfiguration"));
                featureAxisItem.addSelectionListener((SelectionListener)selectionListener);
                MenuItem featureValueFillingItem = new MenuItem(menu, 0);
                featureValueFillingItem.setText(Messages.RowConfigurationWizardPage_eStructuralFeatureValueFillingConfigurationLabel);
                featureValueFillingItem.setData(RowConfigurationWizardPage.E_CLASS, (Object)NattableaxisconfigurationPackage.eINSTANCE.getEClassifier("EStructuralFeatureValueFillingConfiguration"));
                featureValueFillingItem.addSelectionListener((SelectionListener)selectionListener);
                menu.setVisible(true);
                Display display = RowConfigurationWizardPage.this.addAxisConfiguration.getDisplay();
                while (menu.isVisible()) {
                    try {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                    catch (Throwable ex) {
                        System.out.println(ex);
                    }
                }
                if (!display.isDisposed()) {
                    display.update();
                }
            }
        });
        this.editAxisConfiguration = new Button(buttonsComposite, 8);
        this.editAxisConfiguration.setImage(Activator.getDefault().getImage("/icons/Edit_12x12.gif"));
        this.editAxisConfiguration.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        this.editAxisConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedObject = treeViewer.getStructuredSelection().getFirstElement();
                RowConfigurationWizardPage.this.editAxisConfiguration((EObject)selectedObject);
            }
        });
        this.removeAxisConfiguration = new Button(buttonsComposite, 8);
        this.removeAxisConfiguration.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.removeAxisConfiguration.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        this.removeAxisConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator selectedObjects = treeViewer.getStructuredSelection().iterator();
                while (selectedObjects.hasNext()) {
                    RowConfigurationWizardPage.this.headerAxisConfiguration.getOwnedAxisConfigurations().remove(selectedObjects.next());
                }
                RowConfigurationWizardPage.this.recalculateAxisConfigurationButtonsAvailability((ISelection)treeViewer.getStructuredSelection());
                treeViewer.refresh();
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RowConfigurationWizardPage.this.recalculateAxisConfigurationButtonsAvailability(event.getSelection());
            }
        });
        treeViewer.setSelection((ISelection)new StructuredSelection());
    }

    protected void recalculateAxisConfigurationButtonsAvailability(ISelection selection) {
        this.editAxisConfiguration.setEnabled(selection instanceof StructuredSelection && 1 == ((StructuredSelection)selection).size() && ((StructuredSelection)selection).getFirstElement() instanceof IAxisConfiguration);
        this.removeAxisConfiguration.setEnabled(selection != null && !selection.isEmpty());
    }

    protected void editAxisConfiguration(EObject object) {
        if (object instanceof PasteEObjectConfiguration) {
            PasteEObjectConfiguration pasteEObjectConfiguration = (PasteEObjectConfiguration)object;
            PasteEObjectConfigurationDialog dialog = new PasteEObjectConfigurationDialog(this.getShell(), pasteEObjectConfiguration);
            if (dialog.open() == 0) {
                PasteEObjectConfiguration modifiedPasteConfiguration = dialog.getModifiedPasteEObjectConfiguration();
                pasteEObjectConfiguration.setDetachedMode(modifiedPasteConfiguration.isDetachedMode());
                pasteEObjectConfiguration.setPastedElementId(modifiedPasteConfiguration.getPastedElementId());
                pasteEObjectConfiguration.setPasteElementContainementFeature(modifiedPasteConfiguration.getPasteElementContainementFeature());
                pasteEObjectConfiguration.getPostActions().addAll((Collection)modifiedPasteConfiguration.getPostActions());
            }
        } else if (object instanceof EStructuralFeatureValueFillingConfiguration) {
            EStructuralFeatureValueFillingConfiguration featureFillingConfiguration = (EStructuralFeatureValueFillingConfiguration)object;
            FeatureFillingConfigurationDialog dialog = new FeatureFillingConfigurationDialog(this.getShell(), featureFillingConfiguration);
            if (dialog.open() == 0) {
                EStructuralFeatureValueFillingConfiguration modifiedFeatureFillingConfiguration = dialog.getModifiedFeatureFillingConfiguration();
                featureFillingConfiguration.setListenFeature(modifiedFeatureFillingConfiguration.getListenFeature());
            }
        } else if (object instanceof TreeFillingConfiguration) {
            TreeFillingConfiguration treeFillingConfiguration = (TreeFillingConfiguration)object;
            TreeFillingConfigurationDialog dialog = new TreeFillingConfigurationDialog(this.getShell(), treeFillingConfiguration, (List<ILabelProviderConfiguration>)this.headerAxisConfiguration.getOwnedLabelConfigurations(), this.getPasteConfigurations());
            if (dialog.open() == 0) {
                TreeFillingConfiguration modifiedTreeFillingConfiguration = dialog.getModifiedTreeFillingConfiguration();
                treeFillingConfiguration.setDepth(modifiedTreeFillingConfiguration.getDepth());
                treeFillingConfiguration.setLabelProvider(modifiedTreeFillingConfiguration.getLabelProvider());
                treeFillingConfiguration.setPasteConfiguration(modifiedTreeFillingConfiguration.getPasteConfiguration());
                IAxis modifiedAxis = modifiedTreeFillingConfiguration.getAxisUsedAsAxisProvider();
                if (modifiedAxis != null) {
                    IAxis existingAxis = treeFillingConfiguration.getAxisUsedAsAxisProvider();
                    if (existingAxis != null && modifiedAxis.getClass().getSimpleName().equals(existingAxis.getClass().getSimpleName())) {
                        if (existingAxis instanceof EObjectAxis) {
                            ((EObjectAxis)existingAxis).setElement(((EObjectAxis)modifiedAxis).getElement());
                        } else if (existingAxis instanceof EStructuralFeatureAxis) {
                            ((EStructuralFeatureAxis)existingAxis).setElement(((EStructuralFeatureAxis)modifiedAxis).getElement());
                        } else if (existingAxis instanceof EOperationAxis) {
                            ((EOperationAxis)existingAxis).setElement(((EOperationAxis)modifiedAxis).getElement());
                        } else if (existingAxis instanceof FeatureIdAxis) {
                            ((FeatureIdAxis)existingAxis).setElement(((FeatureIdAxis)modifiedAxis).getElement());
                        }
                    } else {
                        treeFillingConfiguration.setAxisUsedAsAxisProvider(modifiedAxis);
                    }
                } else {
                    treeFillingConfiguration.setAxisUsedAsAxisProvider(null);
                }
            }
        }
    }

    protected List<PasteEObjectConfiguration> getPasteConfigurations() {
        ArrayList<PasteEObjectConfiguration> pasteConfigurations = new ArrayList<PasteEObjectConfiguration>();
        for (IAxisConfiguration axisConfiguration : this.headerAxisConfiguration.getOwnedAxisConfigurations()) {
            if (!(axisConfiguration instanceof PasteEObjectConfiguration)) continue;
            pasteConfigurations.add((PasteEObjectConfiguration)axisConfiguration);
        }
        return pasteConfigurations;
    }

    protected TreeViewer createAxisConfigurationTreeViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(new Tree(parent, 68354));
        this.createAxisConfigurationsColumns(treeViewer);
        Tree tree = treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)new NattableaxisconfigurationItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new NattableaxisItemProviderAdapterFactory());
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public Object[] getElements(Object object) {
                Object[] elements = super.getElements(object);
                ArrayList<Object> elementsList = new ArrayList<Object>(Arrays.asList(elements));
                Iterator elementsIterator = elementsList.iterator();
                while (elementsIterator.hasNext()) {
                    if (elementsIterator.next() instanceof IAxisConfiguration) continue;
                    elementsIterator.remove();
                }
                return elementsList.toArray();
            }
        };
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setInput((Object)this.headerAxisConfiguration);
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.refresh();
        return treeViewer;
    }

    protected void createAxisConfigurationsColumns(TreeViewer treeViewer) {
        int[] bounds = new int[]{600};
        String[] titles = new String[]{Messages.RowConfigurationWizardPage_axisConfigurationsColumnName};
        TreeViewerColumn axisManagerIdColumn = this.createTreeViewerColumn(treeViewer, titles[0], bounds[0]);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)new NattableaxisconfigurationItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new NattableaxisItemProviderAdapterFactory());
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        axisManagerIdColumn.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)labelProvider));
    }

    protected TreeViewerColumn createTreeViewerColumn(TreeViewer viewer, String title, int width) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(viewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(width);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    @Override
    public AxisManagerRepresentation createAxisManagerRepresentation() {
        AxisManagerRepresentation createdRepresentation = super.createAxisManagerRepresentation();
        createdRepresentation.setLabelProviderContext("org.eclipse.papyrus.infra.nattable.header.labelprovider");
        return createdRepresentation;
    }

    @Override
    protected void createAxisManagersColumns(final TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        final Set knownAxis = AxisManagerFactory.INSTANCE.getAllRegisteredAxisManager().keySet();
        int[] bounds = new int[]{500, 500};
        String[] titles = new String[]{Messages.ConfigurationWizardPage_axisManagerIdColumnName, Messages.ConfigurationWizardPage_labelProviderContextColumnName};
        TableViewerColumn axisManagerIdColumn = this.createTableViewerColumn(tableViewer, titles[0], bounds[0]);
        ColumnLabelProvider axisManagerIdLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                StringBuilder value = new StringBuilder();
                if (element instanceof AxisManagerRepresentation) {
                    String axisManagerId = ((AxisManagerRepresentation)element).getAxisManagerId();
                    boolean existSimpleName = NameSimplifier.axisManagerNames.containsKey(axisManagerId);
                    if (existSimpleName) {
                        value.append(NameSimplifier.axisManagerNames.get(axisManagerId));
                        value.append(" (");
                    }
                    value.append(axisManagerId != null ? axisManagerId : "");
                    if (existSimpleName) {
                        value.append(")");
                    }
                }
                return value.toString();
            }
        };
        axisManagerIdColumn.setLabelProvider((CellLabelProvider)axisManagerIdLabelProvider);
        axisManagerIdColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)axisManagerIdLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                if (element instanceof AxisManagerRepresentation) {
                    if (NameSimplifier.axisManagerNames.containsValue(value)) {
                        for (Map.Entry<String, String> entry : NameSimplifier.axisManagerNames.entrySet()) {
                            if (!((String)value).contains(entry.getValue()) || !((String)value).contains(entry.getKey())) continue;
                            ((AxisManagerRepresentation)element).setAxisManagerId(entry.getKey());
                        }
                    } else {
                        ((AxisManagerRepresentation)element).setAxisManagerId((String)value);
                    }
                    RowConfigurationWizardPage.this.manageLabelProviderConfiguration((AxisManagerRepresentation)element);
                    tableViewer.refresh();
                    RowConfigurationWizardPage.this.setPageComplete(RowConfigurationWizardPage.this.isPageComplete());
                }
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new ExtendedComboBoxCellEditor((Composite)table, RowConfigurationWizardPage.this.createAxisManagerIdItems(requiredProposedAxisManagers, knownAxis), (ILabelProvider)new LabelProvider(), 0){

                    public Object doGetValue() {
                        if (this.getControl() instanceof CCombo) {
                            return ((CCombo)this.getControl()).getText();
                        }
                        return super.doGetValue();
                    }
                };
            }
        });
        TableViewerColumn labelProviderContextColumn = this.createTableViewerColumn(tableViewer, titles[1], bounds[1]);
        ColumnLabelProvider labelProviderContextLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = "";
                if (element instanceof AxisManagerRepresentation) {
                    result = NameSimplifier.labelProviderContextNames.containsKey(((AxisManagerRepresentation)element).getLabelProviderContext()) ? NameSimplifier.labelProviderContextNames.get(((AxisManagerRepresentation)element).getLabelProviderContext()) : ((AxisManagerRepresentation)element).getLabelProviderContext();
                }
                return result;
            }
        };
        labelProviderContextColumn.setLabelProvider((CellLabelProvider)labelProviderContextLabelProvider);
    }
}

