/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.cdo.core.IResourceSetDisposalApprover;

class CompositeResourceSetDisposalApprover
implements IResourceSetDisposalApprover {
    private final List<IResourceSetDisposalApprover> approvers = Lists.newArrayListWithExpectedSize((int)1);

    CompositeResourceSetDisposalApprover() {
    }

    @Override
    public IResourceSetDisposalApprover.DisposeAction disposalRequested(CDOCheckout checkout, Collection<ResourceSet> resourceSets) {
        IResourceSetDisposalApprover.DisposeAction result = IResourceSetDisposalApprover.DisposeAction.CLOSE;
        if (!resourceSets.isEmpty() && !this.approvers.isEmpty()) {
            for (IResourceSetDisposalApprover next : this.approvers) {
                IResourceSetDisposalApprover.DisposeAction action = this.wrapNull(next.disposalRequested(checkout, resourceSets));
                IResourceSetDisposalApprover.DisposeAction disposeAction = result = result.compareTo(action) > 0 ? action : result;
                if (result == IResourceSetDisposalApprover.DisposeAction.NONE) break;
            }
        }
        return result;
    }

    private IResourceSetDisposalApprover.DisposeAction wrapNull(IResourceSetDisposalApprover.DisposeAction action) {
        return action == null ? IResourceSetDisposalApprover.DisposeAction.NONE : action;
    }

    void addApprover(IResourceSetDisposalApprover approver) {
        if (!this.approvers.contains(approver)) {
            this.approvers.add(approver);
        }
    }

    void removeApprover(IResourceSetDisposalApprover approver) {
        this.approvers.remove(approver);
    }
}

