/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.services;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.utilities.IllegalLibraryException;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.xtext.base.cs2as.AmbiguitiesAdapter;
import org.eclipse.ocl.xtext.base.cs2as.ExceptionAdapter;
import org.eclipse.ocl.xtext.base.scoping.BaseScopeProvider;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class BaseLinkingService
extends DefaultLinkingService {
    public static final @NonNull TracingOption DEBUG_RETRY = new TracingOption("org.eclipse.ocl.xtext.base", "debug/retry");
    private static int depth = -1;
    @Inject
    private IValueConverterService valueConverterService;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        try {
            EList eAdapters;
            Adapter adapter;
            ++depth;
            String text = this.getText(node);
            boolean traceLookup = BaseScopeProvider.LOOKUP.isActive();
            if (text == null || "".equals(text)) {
                if (traceLookup) {
                    BaseScopeProvider.LOOKUP.println(depth + " Lookup null");
                }
                List<EObject> list = Collections.emptyList();
                return list;
            }
            IScope scope = this.getScope(context, ref);
            if (traceLookup) {
                BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text);
            }
            if (scope == null) {
                List<EObject> list = Collections.emptyList();
                return list;
            }
            QualifiedName qualifiedName = QualifiedName.create((String)text);
            List<EObject> linkedObjects = this.lookUp(scope, qualifiedName);
            if (linkedObjects.size() <= 0 && text.startsWith("_")) {
                linkedObjects = this.lookUp(scope, QualifiedName.create((String)text.substring(1)));
            }
            if (traceLookup) {
                BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " failed");
            }
            if ((adapter = EcoreUtil.getAdapter((List)(eAdapters = context.eAdapters()), ExceptionAdapter.class)) != null) {
                eAdapters.remove(adapter);
            }
            if (linkedObjects.size() > 1) {
                if (DEBUG_RETRY.isActive()) {
                    scope.getElements(qualifiedName);
                }
                AmbiguitiesAdapter.setAmbiguities(context, linkedObjects);
                List<EObject> list = Collections.emptyList();
                return list;
            }
            if (linkedObjects.size() <= 0 && DEBUG_RETRY.isActive()) {
                scope.getElements(qualifiedName);
            }
            List<EObject> list = linkedObjects;
            return list;
        }
        catch (IllegalLibraryException e) {
            context.eAdapters().add((Object)new ExceptionAdapter((Exception)((Object)e)));
            List<EObject> list = Collections.emptyList();
            return list;
        }
        finally {
            --depth;
        }
    }

    protected IScope getScope(EObject context, EReference reference) {
        IScopeProvider scopeProvider = this.getScopeProvider();
        if (scopeProvider == null) {
            throw new IllegalStateException("scopeProvider must not be null.");
        }
        return scopeProvider.getScope(context, reference);
    }

    public @Nullable String getText(@Nullable INode node) {
        if (node == null) {
            return null;
        }
        ILeafNode leafNode = ElementUtil.getLeafNode(node);
        if (leafNode == null) {
            return null;
        }
        EObject grammarElement = leafNode.getGrammarElement();
        if (grammarElement == null) {
            return null;
        }
        String ruleName = this.getLinkingHelper().getRuleNameFrom(grammarElement);
        return (String)this.valueConverterService.toValue(leafNode.getText(), ruleName, (INode)leafNode);
    }

    protected List<EObject> lookUp(@NonNull IScope scope, QualifiedName qualifiedName) {
        @NonNull ArrayList<EObject> linkedObjects = new ArrayList<EObject>();
        for (IEObjectDescription eObjectDescription : scope.getElements(qualifiedName)) {
            EObject eObjectOrProxy = eObjectDescription.getEObjectOrProxy();
            linkedObjects.add(eObjectOrProxy);
            if (!BaseScopeProvider.LOOKUP.isActive()) continue;
            BaseScopeProvider.LOOKUP.println(depth + " Lookup " + qualifiedName + " => " + eObjectOrProxy);
        }
        return linkedObjects;
    }
}

