/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.commit;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchCreationContext;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchPointImpl;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitDataImpl;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.CheckUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOCommitInfoImpl
extends CDOBranchPointImpl
implements CDOCommitInfo,
IAdaptable {
    private InternalCDOCommitInfoManager commitInfoManager;
    private long previousTimeStamp;
    private String userID;
    private String comment;
    private CDOCommitData commitData;

    public CDOCommitInfoImpl(InternalCDOCommitInfoManager commitInfoManager, CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOCommitData commitData) {
        super(branch, timeStamp);
        CheckUtil.checkArg((Object)commitInfoManager, (String)"commitInfoManager");
        this.commitInfoManager = commitInfoManager;
        this.previousTimeStamp = previousTimeStamp;
        this.userID = userID;
        this.comment = comment;
        this.commitData = commitData;
    }

    @Override
    public InternalCDOCommitInfoManager getCommitInfoManager() {
        return this.commitInfoManager;
    }

    @Override
    public long getPreviousTimeStamp() {
        return this.previousTimeStamp;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isInitialCommit() {
        return "CDO_SYSTEM".equals(this.userID);
    }

    @Override
    public boolean isEmpty() {
        this.loadCommitDataIfNeeded();
        return this.commitData.isEmpty();
    }

    @Override
    public CDOChangeSetData copy() {
        return this.commitData == null ? null : this.commitData.copy();
    }

    @Override
    public void merge(CDOChangeSetData changeSetData) {
        this.loadCommitDataIfNeeded();
        this.commitData.merge(changeSetData);
    }

    @Override
    public synchronized List<CDOPackageUnit> getNewPackageUnits() {
        this.loadCommitDataIfNeeded();
        return this.commitData.getNewPackageUnits();
    }

    @Override
    public synchronized List<CDOIDAndVersion> getNewObjects() {
        this.loadCommitDataIfNeeded();
        return this.commitData.getNewObjects();
    }

    @Override
    public synchronized List<CDORevisionKey> getChangedObjects() {
        this.loadCommitDataIfNeeded();
        return this.commitData.getChangedObjects();
    }

    @Override
    public synchronized List<CDOIDAndVersion> getDetachedObjects() {
        this.loadCommitDataIfNeeded();
        return this.commitData.getDetachedObjects();
    }

    @Override
    public Map<CDOID, CDOChangeKind> getChangeKinds() {
        this.loadCommitDataIfNeeded();
        return this.commitData.getChangeKinds();
    }

    @Override
    public CDOChangeKind getChangeKind(CDOID id) {
        this.loadCommitDataIfNeeded();
        return this.commitData.getChangeKind(id);
    }

    public Object getAdapter(Class adapter) {
        CDOCommonRepository repository;
        if (adapter == CDOBranchCreationContext.class && (repository = this.getBranch().getBranchManager().getRepository()).isSupportingBranches()) {
            return new CDOBranchCreationContext(){

                public CDOBranchPoint getBase() {
                    return CDOCommitInfoImpl.this;
                }
            };
        }
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    @Override
    public int hashCode() {
        long timeStamp = this.getTimeStamp();
        int prime = 31;
        int result = 0;
        result = 31 * result + (this.commitInfoManager == null ? 0 : this.commitInfoManager.hashCode());
        result = 31 * result + (int)(timeStamp ^ timeStamp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CDOCommitInfoImpl)) {
            return false;
        }
        CDOCommitInfoImpl other = (CDOCommitInfoImpl)obj;
        if (this.commitInfoManager != other.commitInfoManager) {
            return false;
        }
        return this.getTimeStamp() == other.getTimeStamp();
    }

    @Override
    public String toString() {
        return CDOCommitInfoImpl.toString(this);
    }

    public static String toString(CDOCommitInfo commitInfo) {
        String data = null;
        if (commitInfo.isCommitDataLoaded()) {
            data = CDOCommitDataImpl.toString(commitInfo);
        }
        long t = commitInfo.getTimeStamp();
        String timeStamp = String.valueOf(CDOCommonUtil.formatTimeStamp(t)) + " (" + t + ")";
        return MessageFormat.format("CommitInfo[{0}, {1}, {2}, {3}, {4}]", timeStamp, commitInfo.getBranch(), commitInfo.getUserID(), commitInfo.getComment(), data);
    }

    @Override
    public synchronized boolean isCommitDataLoaded() {
        return this.commitData != null;
    }

    private synchronized void loadCommitDataIfNeeded() {
        if (this.commitData == null) {
            this.commitData = this.commitInfoManager.getCommitInfoLoader().loadCommitData(this.getTimeStamp());
        }
    }
}

