/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.ui.actions.EditingDomainAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportRootsAction
extends EditingDomainAction {
    public static final String ID = "import-roots";
    private static final String TITLE = Messages.getString("ImportRootsAction.1");
    private CDOResource targetResource;
    private transient List<URI> uris;

    public ImportRootsAction() {
        super(String.valueOf(TITLE) + INTERACTIVE);
        this.setId(ID);
    }

    public CDOResource getTargetResource() {
        return this.targetResource;
    }

    public void setTargetResource(CDOResource targetResource) {
        this.targetResource = targetResource;
    }

    public boolean isEnabled() {
        return this.targetResource != null && super.isEnabled();
    }

    protected void preRun() throws Exception {
        ResourceDialog dialog = new ResourceDialog(this.getShell(), TITLE, 4098){

            protected boolean processResources() {
                return true;
            }
        };
        if (dialog.open() == 0) {
            this.uris = dialog.getURIs();
        } else {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        EList targetContents = this.targetResource.getContents();
        List<Resource> resources = this.getSourceResources();
        for (Resource resource : resources) {
            ArrayList contents = new ArrayList(resource.getContents());
            for (EObject root : contents) {
                targetContents.add((Object)root);
            }
        }
    }

    protected List<Resource> getSourceResources() {
        ResourceSetImpl resourceSet = this.createSourceResourceSet();
        ArrayList<Resource> resources = new ArrayList<Resource>(this.uris.size());
        for (URI uri : this.uris) {
            Resource resource = resourceSet.getResource(uri, true);
            resources.add(resource);
        }
        return resources;
    }

    protected ResourceSetImpl createSourceResourceSet() {
        CDOView view = this.targetResource.cdoView();
        CDOSession session = view.getSession();
        CDOPackageRegistry packageRegistry = session.getPackageRegistry();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry((EPackage.Registry)packageRegistry);
        return resourceSet;
    }
}

