/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.ui.actions.AbstractViewAction;
import org.eclipse.emf.cdo.internal.ui.dialogs.ExportResourceDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportResourceAction
extends AbstractViewAction {
    public static final String ID = "export-resource";
    private static final String TITLE = Messages.getString("ExportResourceAction.1");
    private URI sourceURI;
    private String targetPath;

    public ExportResourceAction(IWorkbenchPage page, CDOView view) {
        super(page, String.valueOf(TITLE) + INTERACTIVE, Messages.getString("ExportResourceAction.2"), SharedIcons.getDescriptor((String)"etool16/export.gif"), view);
        this.setId(ID);
    }

    protected void preRun() throws Exception {
        ExportResourceDialog dialog = new ExportResourceDialog(this.getShell(), TITLE, 4096);
        if (dialog.open() == 0) {
            List uris = dialog.getURIs();
            if (uris.size() == 1) {
                this.sourceURI = (URI)uris.get(0);
                this.targetPath = dialog.getTargetPath();
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)Messages.getString("ExportResourceAction.3"));
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        CDOView view = this.getView();
        CDOResource source = view.getResource(this.targetPath);
        ArrayList<EObject> sourceContents = new ArrayList<EObject>((Collection<EObject>)source.getContents());
        this.exportObjects(sourceContents);
    }

    private void exportObjects(List<EObject> sourceContents) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.createResource(this.sourceURI);
        Collection copiedRoots = EcoreUtil.copyAll(sourceContents);
        resource.getContents().addAll(copiedRoots);
        try {
            resource.save(null);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }
}

