/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.Comparator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

public class AxisComparator
implements Comparator<IAxis> {
    private boolean alphabeticOrder;
    private IConfigRegistry configRegistry;
    private LabelProviderContextElementWrapper wrapper1;
    private LabelProviderContextElementWrapper wrapper2;

    public AxisComparator(boolean alphabticOrder, IConfigRegistry configRegistry) {
        this.alphabeticOrder = alphabticOrder;
        this.configRegistry = configRegistry;
        this.wrapper1 = new LabelProviderContextElementWrapper();
        this.wrapper2 = new LabelProviderContextElementWrapper();
        this.wrapper1.setConfigRegistry(configRegistry);
        this.wrapper2.setConfigRegistry(configRegistry);
    }

    @Override
    public int compare(IAxis arg0, IAxis arg1) {
        LabelProviderService serv = (LabelProviderService)this.configRegistry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        this.wrapper1.setObject(arg0);
        this.wrapper2.setObject(arg1);
        ILabelProvider provider = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.header.labelprovider");
        String str1 = provider.getText((Object)this.wrapper1).replaceAll("[^\\w\\s]", "");
        String str2 = provider.getText((Object)this.wrapper2).replaceAll("[^\\w\\s]", "");
        if (this.alphabeticOrder) {
            return str1.compareToIgnoreCase(str2);
        }
        return str2.compareToIgnoreCase(str1);
    }

    @Deprecated
    protected String getText(LabelProviderService serv, Object obj) {
        ILabelProvider provider = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.header.labelprovider");
        LabelProviderContextElementWrapper wrapper = new LabelProviderContextElementWrapper();
        wrapper.setConfigRegistry(this.configRegistry);
        wrapper.setObject(obj);
        return provider.getText((Object)wrapper);
    }
}

