/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.opencert.vocabulary.Category;
import org.eclipse.opencert.vocabulary.Term;
import org.eclipse.opencert.vocabulary.diagram.edit.policies.VocabularyBaseItemSemanticEditPolicy;

public class CategoryTermsReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public CategoryTermsReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Category)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Term) || !(this.newEnd instanceof Category)) {
            return false;
        }
        return VocabularyBaseItemSemanticEditPolicy.getLinkConstraints().canExistCategoryTerms_4001(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Term) || !(this.newEnd instanceof Term)) {
            return false;
        }
        return VocabularyBaseItemSemanticEditPolicy.getLinkConstraints().canExistCategoryTerms_4001(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getTerms().remove((Object)this.getOldTarget());
        this.getNewSource().getTerms().add((Object)this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().getTerms().remove((Object)this.getOldTarget());
        this.getOldSource().getTerms().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Category getOldSource() {
        return (Category)this.referenceOwner;
    }

    protected Category getNewSource() {
        return (Category)this.newEnd;
    }

    protected Term getOldTarget() {
        return (Term)this.oldEnd;
    }

    protected Term getNewTarget() {
        return (Term)this.newEnd;
    }
}

