/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.parser.custom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationConstraintHelper;
import org.eclipse.papyrus.uml.diagram.sequence.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class TimeConstraintParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String LINE_BREAK = System.getProperty("line.separator");
    private static final String FORMAT = "{%s}";

    public TimeConstraintParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    public TimeConstraintParser(EAttribute[] features) {
        super(features);
    }

    public TimeConstraintParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Object adapter = element.getAdapter(EObject.class);
        if (adapter instanceof TimeConstraint) {
            TimeConstraint constraint = (TimeConstraint)adapter;
            ValueSpecification spec = constraint.getSpecification();
            return String.format(FORMAT, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)spec));
        }
        if (adapter instanceof DurationConstraint) {
            String value = this.getDurationConstraint((DurationConstraint)adapter);
            return String.format(FORMAT, value);
        }
        if (adapter instanceof Message) {
            StringBuffer result = new StringBuffer();
            Message message = (Message)adapter;
            MessageEnd event1 = message.getSendEvent();
            MessageEnd event2 = message.getReceiveEvent();
            List constraints = DurationConstraintHelper.getDurationConstraintsBetween((NamedElement)event1, (NamedElement)event2);
            for (DurationConstraint constraint : constraints) {
                if (result.length() > 0) {
                    result.append(LINE_BREAK);
                }
                ValueSpecification spec = constraint.getSpecification();
                result.append(String.format(FORMAT, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)spec)));
            }
            return result.toString();
        }
        return "";
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        HashSet<Object> semanticElementsBeingParsed = new HashSet<Object>();
        if (element instanceof Constraint) {
            Constraint constraint = (Constraint)element;
            ValueSpecificationUtil.addEnclosedValueSpecificationToCollection((ValueSpecification)constraint.getSpecification(), semanticElementsBeingParsed);
        } else if (element instanceof Message) {
            Message message = (Message)element;
            semanticElementsBeingParsed.add(message);
            MessageEnd event1 = message.getSendEvent();
            semanticElementsBeingParsed.add(event1);
            MessageEnd event2 = message.getReceiveEvent();
            semanticElementsBeingParsed.add(event2);
            List constraints = DurationConstraintHelper.getDurationConstraintsBetween((NamedElement)event1, (NamedElement)event2);
            for (DurationConstraint constraint : constraints) {
                semanticElementsBeingParsed.add(constraint);
                semanticElementsBeingParsed.add(constraint.getOwner());
            }
        }
        return new ArrayList(semanticElementsBeingParsed);
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getConstraint_Specification().equals(feature) || ValueSpecification.class.isAssignableFrom(feature.getContainerClass());
    }

    @Override
    public String getEditString(IAdaptable adapter, int flags) {
        EObject element = (EObject)adapter.getAdapter(EObject.class);
        if (element instanceof DurationConstraint) {
            return this.getDurationConstraint((DurationConstraint)element);
        }
        return super.getEditString(adapter, flags);
    }

    protected String getDurationConstraint(DurationConstraint constraint) {
        String max;
        Interval interval;
        String min;
        ValueSpecification spec = constraint.getSpecification();
        if (spec instanceof Interval && (min = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)(interval = (Interval)spec).getMin())).equals(max = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)interval.getMax()))) {
            return min;
        }
        String value = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)spec);
        return value;
    }

    @Override
    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        EObject element = (EObject)adapter.getAdapter(EObject.class);
        if (element instanceof DurationConstraint) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)element);
            if (editingDomain == null) {
                return UnexecutableCommand.INSTANCE;
            }
            Object[] values = this.parseInterval(newString);
            if (values == null || values.length != 2) {
                return UnexecutableCommand.INSTANCE;
            }
            return new UpdateDurationConstraintCommand(editingDomain, (DurationConstraint)element, values[0], values[1]);
        }
        return super.getParseCommand(adapter, newString, flags);
    }

    private Object[] parseInterval(String newString) {
        int pos = newString.indexOf("..");
        if (pos > -1) {
            Object[] part = new String[]{newString.substring(0, pos), newString.substring(pos + 2)};
            try {
                int min = Integer.parseInt(part[0].trim());
                int max = Integer.parseInt(((String)part[1]).trim());
                return new Integer[]{min, max};
            }
            catch (Exception exception) {
                return part;
            }
        }
        try {
            int value = Integer.parseInt(newString);
            return new Integer[]{value, value};
        }
        catch (Exception exception) {
            return new String[]{newString, newString};
        }
    }

    static class UpdateDurationConstraintCommand
    extends AbstractTransactionalCommand {
        private DurationConstraint constraint;
        private Object min;
        private Object max;

        public UpdateDurationConstraintCommand(TransactionalEditingDomain domain, DurationConstraint constraint, Object min, Object max) {
            super(domain, "Set Values", null);
            this.constraint = constraint;
            this.min = min;
            this.max = max;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ValueSpecification spec = this.constraint.getSpecification();
            if (spec instanceof Interval) {
                Interval interval = (Interval)spec;
                this.setValue(interval.getMin(), this.min);
                this.setValue(interval.getMax(), this.max);
            }
            return CommandResult.newOKCommandResult();
        }

        private void setValue(ValueSpecification spec, Object val) {
            if (spec instanceof Duration) {
                Duration dur = (Duration)spec;
                if (dur.getExpr() instanceof LiteralInteger && val instanceof Integer) {
                    ((LiteralInteger)dur.getExpr()).setValue(((Integer)val).intValue());
                } else {
                    LiteralString str = UMLFactory.eINSTANCE.createLiteralString();
                    str.setValue(val.toString());
                    dur.setExpr((ValueSpecification)str);
                }
            }
        }
    }
}

