/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.impl;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.predicates.ImportedPredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.impl.PredicateImpl;

public class ImportedPredicateImpl
extends PredicateImpl
implements ImportedPredicate {
    protected static final boolean ACCESSIBLE_EDEFAULT = true;
    protected boolean accessible = true;

    protected ImportedPredicateImpl() {
    }

    protected EClass eStaticClass() {
        return PredicatesPackage.Literals.IMPORTED_PREDICATE;
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public void setAccessible(boolean newAccessible) {
        boolean oldAccessible = this.accessible;
        this.accessible = newAccessible;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldAccessible, this.accessible));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.isAccessible();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setAccessible((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setAccessible(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return !this.accessible;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (accessible: ");
        result.append(this.accessible);
        result.append(')');
        return result.toString();
    }

    public boolean matches(IResource resource) {
        if (resource != null) {
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                URI location = resource.getLocationURI();
                if (resource.getType() == 1) {
                    IFile[] files = root.findFilesForLocationURI(location);
                    if (files.length != 0) {
                        return this.checkAccessible((IResource[])files);
                    }
                } else {
                    IContainer[] containers = root.findContainersForLocationURI(location);
                    if (containers.length != 0) {
                        return this.checkAccessible((IResource[])containers);
                    }
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private boolean checkAccessible(IResource[] resources) {
        if (this.isAccessible()) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.isAccessible()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }
}

