/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.setup.Configuration;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.presentation.Messages;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.Request;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class NotificationViewPart
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.oomph.setup.presentation.NotificationView";
    private Browser browser;
    private Annotation notification;

    public void setNotification(Annotation notification) {
        this.notification = notification;
        if ("true".equals(notification.getDetails().get((Object)"maximize"))) {
            IWorkbenchPage page = this.getSite().getPage();
            page.setPartState(page.getReference((IWorkbenchPart)this), 1);
        }
        this.setUrl(this.getNotificationURI());
    }

    private String getNotificationURI() {
        return (String)this.notification.getDetails().get((Object)"uri");
    }

    private void setUrl(String url) {
        Request request = new Request(url);
        IProduct product = Platform.getProduct();
        if (product != null) {
            Bundle definingBundle;
            String application;
            request.put((Object)"product-id", (Object)product.getId());
            String name = product.getName();
            if (name != null) {
                request.put((Object)"product-name", (Object)name);
            }
            if ((application = product.getApplication()) != null) {
                request.put((Object)"application-id", (Object)application);
            }
            if ((definingBundle = product.getDefiningBundle()) != null) {
                String symbolicName = definingBundle.getSymbolicName();
                request.put((Object)"bundle-id", (Object)symbolicName);
                Version version = definingBundle.getVersion();
                request.put((Object)"bundle-version", (Object)version.toString());
            }
        }
        request.put((Object)"java.version", (Object)System.getProperty("java.version"));
        Composite parent = this.browser.getParent();
        Color foreground = parent.getForeground();
        Color background = parent.getBackground();
        request.put((Object)"color", (Object)NotificationViewPart.getColor(foreground));
        request.put((Object)"background-color", (Object)NotificationViewPart.getColor(background));
        URI enhancedURI = request.getURI();
        this.browser.setUrl(enhancedURI.toString());
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.setJavascriptEnabled(true);
        this.browser.addTitleListener(event -> {
            if (!event.title.isBlank()) {
                this.setPartName(event.title);
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                NotificationViewPart.this.browser.removeProgressListener((ProgressListener)this);
                NotificationViewPart.this.browser.setVisible(true);
                UIUtil.asyncExec(() -> NotificationViewPart.this.browser.addLocationListener(new LocationListener(){

                    public void changing(LocationEvent event) {
                        NotificationViewPart.this.handleChanging(event);
                    }

                    public void changed(LocationEvent event) {
                    }
                }));
            }

            public void changed(ProgressEvent event) {
            }
        });
        this.browser.setVisible(false);
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    protected void handleChanging(LocationEvent event) {
        URI location = URI.createURI((String)event.location);
        String scheme = location.scheme();
        if (scheme != null && scheme.startsWith("eclipse+")) {
            event.doit = false;
            if ("eclipse+setup".equals(scheme)) {
                final URI setupURI = this.resolveEclipseURI(location);
                new Job(Messages.NotificationViewPart_ApplyConfigureJob_label){

                    protected IStatus run(IProgressMonitor monitor) {
                        Workspace workspace;
                        ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
                        SetupContext setupContext = SetupContext.create((ResourceSet)resourceSet);
                        Resource resource = resourceSet.getResource(setupURI, true);
                        Configuration configuration = (Configuration)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.CONFIGURATION);
                        Installation installation = configuration.getInstallation();
                        if (installation != null) {
                            setupContext.getInstallation().getSetupTasks().addAll((Collection)installation.getSetupTasks());
                        }
                        if ((workspace = configuration.getWorkspace()) != null) {
                            setupContext.getWorkspace().getSetupTasks().addAll((Collection)workspace.getSetupTasks());
                        }
                        if (installation != null || workspace != null) {
                            UIUtil.asyncExec(() -> 2.lambda$0(configuration, setupContext));
                        }
                        return Status.OK_STATUS;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    private static /* synthetic */ void lambda$0(Configuration var0, SetupContext var1_1) {
                        handlingShell = SetupPropertyTester.getHandlingShell();
                        if (handlingShell != null) {
                            if (!handlingShell.isVisible()) {
                                handlingShell.setVisible(true);
                            }
                            handlingShell.setFocus();
                        } else {
                            oldSystemProperties = new LinkedHashMap<String, String>();
                            systemPropertiesAnnotation = var0.getAnnotation("http://www.eclipse.org/oomph/setup/SystemProperties");
                            if (systemPropertiesAnnotation != null) {
                                for (Map.Entry entry : systemPropertiesAnnotation.getDetails()) {
                                    oldSystemProperties.put((String)entry.getKey(), System.setProperty((String)entry.getKey(), (String)entry.getValue()));
                                }
                            }
                            try {
                                SetupWizard.Updater.perform((SetupContext)var1_1);
                            }
                            finally {
                                ** for (entry : oldSystemProperties.entrySet())
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (entry.getValue() == null) {
                                    System.clearProperty((String)entry.getKey());
                                    continue;
                                }
                                System.setProperty((String)entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                        }
lbl27:
                        // 2 sources

                    }
                }.schedule();
            } else if ("eclipse+external".equals(scheme)) {
                int style = 128;
                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    IWebBrowser browser = browserSupport.createBrowser(style, "", "", "");
                    browser.openURL(new URL(this.resolveEclipseURI(location).toString()));
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log((Throwable)ex, 2);
                }
            } else if ("eclipse+command".equals(scheme)) {
                String opaquePart = location.opaquePart();
                if ("close".equals(opaquePart)) {
                    this.hide(null);
                } else if ("dismiss".equals(opaquePart)) {
                    this.hide(SetupContext.GLOBAL_SETUPS_LOCATION_URI);
                } else if ("dismiss-installation".equals(opaquePart)) {
                    this.hide(SetupContext.CONFIGURATION_STATE_LOCATION_URI);
                } else if ("dismiss-workspace".equals(opaquePart)) {
                    this.hide(SetupContext.WORKSPACE_STATE_LOCATION_URI);
                }
            }
        }
    }

    private void hide() {
        this.getSite().getPage().hideView((IViewPart)this);
    }

    private void hide(URI uri) {
        this.hide();
        if (uri != null) {
            SetupUIPlugin.rememberNotificationURI((String)this.getNotificationURI(), (URI)uri);
        }
    }

    private URI resolveEclipseURI(URI location) {
        String opaquePart = location.opaquePart();
        if (opaquePart != null) {
            URI underlyingURI = URI.createURI((String)opaquePart);
            if (underlyingURI.isRelative()) {
                URI baseURI = URI.createURI((String)this.browser.getUrl());
                underlyingURI = underlyingURI.resolve(baseURI);
            }
            return underlyingURI;
        }
        return location;
    }

    private static String getColor(Color color) {
        StringBuilder result = new StringBuilder(9);
        result.append('#');
        int red = color.getRed();
        if (red < 16) {
            result.append('0');
        }
        result.append(Integer.toHexString(red));
        int green = color.getGreen();
        if (green < 16) {
            result.append('0');
        }
        result.append(Integer.toHexString(green));
        int blue = color.getBlue();
        if (blue < 16) {
            result.append('0');
        }
        result.append(Integer.toHexString(blue));
        int alpha = color.getAlpha();
        if (alpha < 16) {
            result.append('0');
        }
        result.append(Integer.toHexString(alpha));
        return result.toString();
    }
}

