/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.ITargletContainerDescriptor;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptor;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.pde.TargetPlatformRunnable;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;

public final class TargletContainerDescriptorManager {
    public static final String WORKSPACE_LOCATION = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
    private static final String STATE_PATH = ".metadata/.plugins/" + TargletsCorePlugin.INSTANCE.getSymbolicName();
    private static final String WORKSPACE_STATE_RELATIVE_PATH = String.valueOf(STATE_PATH) + "/descriptors.bin";
    private static final String WORKSPACE_REFERENCER_RELATIVE_PATH = String.valueOf(STATE_PATH) + "/profiles.txt";
    private static final File WORKSPACE_STATE_FILE = new File(WORKSPACE_LOCATION, WORKSPACE_STATE_RELATIVE_PATH);
    public static final File WORKSPACE_REFERENCER_FILE = new File(WORKSPACE_LOCATION, WORKSPACE_REFERENCER_RELATIVE_PATH);
    private static TargletContainerDescriptorManager instance;
    private final CountDownLatch initialized = new CountDownLatch(1);
    private Throwable initializationProblem;
    private Map<String, TargletContainerDescriptor> descriptors;

    private TargletContainerDescriptorManager() throws CoreException {
        this.initializeSync(null);
    }

    private void initialize(IProgressMonitor monitor) throws CoreException {
        if (WORKSPACE_STATE_FILE.exists()) {
            try {
                this.descriptors = TargletContainerDescriptorManager.loadDescriptors(WORKSPACE_STATE_FILE);
            }
            catch (Exception ex) {
                TargletsCorePlugin.INSTANCE.log(ex);
            }
        }
        if (this.descriptors == null) {
            this.descriptors = new HashMap<String, TargletContainerDescriptor>();
        }
    }

    private void waitUntilInitialized(IProgressMonitor monitor) throws CoreException {
        try {
            do {
                TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
            } while (!this.initialized.await(100L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (this.initializationProblem != null) {
            TargletsCorePlugin.INSTANCE.coreException(this.initializationProblem);
        }
    }

    public TargletContainerDescriptor getDescriptor(String id, IProgressMonitor monitor) throws CoreException {
        this.waitUntilInitialized(monitor);
        TargletContainerDescriptor descriptor = this.descriptors.get(id);
        if (descriptor == null) {
            File poolLocation = TargletContainerDescriptorManager.getDefaultPoolLocation();
            descriptor = new TargletContainerDescriptor(id, poolLocation);
            this.descriptors.put(id, descriptor);
            this.saveDescriptors(monitor);
        }
        return descriptor;
    }

    public void removeDescriptor(String id) {
        if (this.descriptors.remove(id) != null) {
            this.saveDescriptors((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public IProfileChangeRequest createProfileChangeRequest(ITargletContainerDescriptor descriptor, IProfile profile) {
        return descriptor.getBundlePool().getAgent().getPlanner().createChangeRequest(profile);
    }

    public void saveDescriptors(IProgressMonitor monitor) {
        Set<String> containerIDs = TargletContainerDescriptorManager.getContainerIDs(monitor);
        this.descriptors.keySet().retainAll(containerIDs);
        WORKSPACE_STATE_FILE.getParentFile().mkdirs();
        FileOutputStream outputStream = null;
        ArrayList<String> ids = new ArrayList<String>();
        try {
            try {
                outputStream = new FileOutputStream(WORKSPACE_STATE_FILE);
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
                options.put("DATA_CONVERTER", Boolean.TRUE);
                options.put("BUFFER_CAPACITY", 8192);
                BinaryResourceImpl.EObjectOutputStream stream = new BinaryResourceImpl.EObjectOutputStream((OutputStream)outputStream, options);
                stream.writeInt(this.descriptors.size());
                for (ITargletContainerDescriptor iTargletContainerDescriptor : this.descriptors.values()) {
                    ((TargletContainerDescriptor)iTargletContainerDescriptor).write(stream);
                    String id = iTargletContainerDescriptor.getWorkingProfileID();
                    if (id == null) continue;
                    ids.add(id);
                }
                stream.flush();
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(outputStream);
            throw throwable;
        }
        IOUtil.close((Closeable)outputStream);
        Collections.sort(ids);
        WORKSPACE_REFERENCER_FILE.getParentFile().mkdirs();
        IOUtil.writeLines((File)WORKSPACE_REFERENCER_FILE, null, ids);
    }

    private void initializeSync(IProgressMonitor monitor) {
        try {
            try {
                this.initialize(monitor);
            }
            catch (Throwable t) {
                this.initializationProblem = t;
                TargletsCorePlugin.INSTANCE.log(t);
                this.initialized.countDown();
            }
        }
        finally {
            this.initialized.countDown();
        }
    }

    private static Map<String, TargletContainerDescriptor> loadDescriptors(File file) {
        HashMap<String, TargletContainerDescriptor> hashMap;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
            options.put("DATA_CONVERTER", Boolean.TRUE);
            options.put("BUFFER_CAPACITY", 8192);
            BinaryResourceImpl.EObjectInputStream stream = new BinaryResourceImpl.EObjectInputStream((InputStream)in, options);
            int size = stream.readInt();
            HashMap<String, TargletContainerDescriptor> result = new HashMap<String, TargletContainerDescriptor>();
            int i = 0;
            while (i < size) {
                TargletContainerDescriptor descriptor = new TargletContainerDescriptor(stream);
                result.put(descriptor.getID(), descriptor);
                ++i;
            }
            hashMap = result;
        }
        catch (IOException ex) {
            try {
                throw new IORuntimeException((Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)in);
        return hashMap;
    }

    public static Set<String> getContainerIDs(final IProgressMonitor monitor) {
        try {
            return (Set)TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Set<String>>(){

                public Set<String> run(ITargetPlatformService service) throws CoreException {
                    HashSet<String> ids = new HashSet<String>();
                    ITargetHandle[] iTargetHandleArray = service.getTargets(monitor);
                    int n = iTargetHandleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITargetHandle targetHandle = iTargetHandleArray[n2];
                        try {
                            ITargetDefinition target = targetHandle.getTargetDefinition();
                            ITargetLocation[] targetLocations = target.getTargetLocations();
                            if (targetLocations != null) {
                                ITargetLocation[] iTargetLocationArray = targetLocations;
                                int n3 = targetLocations.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ITargetLocation location = iTargetLocationArray[n4];
                                    if (location instanceof ITargletContainer) {
                                        ITargletContainer targletContainer = (ITargletContainer)location;
                                        String id = targletContainer.getID();
                                        ids.add(id);
                                    }
                                    ++n4;
                                }
                            }
                        }
                        catch (Exception ex) {
                            TargletsCorePlugin.INSTANCE.log(ex, 2);
                        }
                        ++n2;
                    }
                    return ids;
                }
            });
        }
        catch (CoreException ex) {
            TargletsCorePlugin.INSTANCE.log(ex);
            return null;
        }
    }

    public static ITargletContainer getContainer(final String id) {
        try {
            return (ITargletContainer)TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<ITargletContainer>(){

                public ITargletContainer run(ITargetPlatformService service) throws CoreException {
                    ITargetHandle[] iTargetHandleArray = service.getTargets((IProgressMonitor)new NullProgressMonitor());
                    int n = iTargetHandleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITargetHandle targetHandle = iTargetHandleArray[n2];
                        try {
                            ITargetDefinition target = targetHandle.getTargetDefinition();
                            ITargetLocation[] targetLocations = target.getTargetLocations();
                            if (targetLocations != null) {
                                ITargetLocation[] iTargetLocationArray = targetLocations;
                                int n3 = targetLocations.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ITargletContainer targletContainer;
                                    ITargetLocation location = iTargetLocationArray[n4];
                                    if (location instanceof ITargletContainer && (targletContainer = (ITargletContainer)location).getID().equals(id)) {
                                        return targletContainer;
                                    }
                                    ++n4;
                                }
                            }
                        }
                        catch (Exception ex) {
                            TargletsCorePlugin.INSTANCE.log(ex);
                        }
                        ++n2;
                    }
                    return null;
                }
            });
        }
        catch (CoreException ex) {
            TargletsCorePlugin.INSTANCE.log(ex);
            return null;
        }
    }

    public static File getDefaultPoolLocation() {
        String client;
        AgentManager agentManager = P2Util.getAgentManager();
        BundlePool bundlePool = agentManager.getDefaultBundlePool(client = TargletsCorePlugin.INSTANCE.getSymbolicName());
        if (bundlePool == null) {
            Iterator iterator;
            File agentLocation = agentManager.getDefaultAgentLocation();
            Agent agent = agentManager.getAgent(agentLocation);
            if (agent == null) {
                agent = agentManager.addAgent(agentLocation);
            }
            if ((iterator = agent.getBundlePools().iterator()).hasNext()) {
                BundlePool pool = (BundlePool)iterator.next();
                return pool.getLocation();
            }
            File poolLocation = new File(agentLocation, "pool");
            bundlePool = agent.addBundlePool(poolLocation);
        }
        return bundlePool.getLocation();
    }

    public static synchronized TargletContainerDescriptorManager getInstance() throws CoreException {
        if (instance == null) {
            instance = new TargletContainerDescriptorManager();
        }
        return instance;
    }
}

