/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.lang.reflect.Method;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.ButtonBar;
import org.eclipse.oomph.ui.HelpSupport;
import org.eclipse.oomph.ui.OomphWizardDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public abstract class SetupWizardPage
extends WizardPage
implements HelpSupport.HelpProvider {
    public SetupWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public SetupWizard getWizard() {
        return (SetupWizard)super.getWizard();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        String sectionName = this.getName();
        return UIUtil.getOrCreateSection((IDialogSettings)settings, (String)sectionName);
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return this.getWizard().getAdapterFactory();
    }

    public String getHelpPath() {
        String id = "Doc" + ((Object)((Object)this)).getClass().getSimpleName();
        return "/org.eclipse.oomph.setup.doc/html/user/wizard/" + id + ".html#" + id + "_1_table";
    }

    public ResourceSet getResourceSet() {
        return this.getWizard().getResourceSet();
    }

    public CatalogManager getCatalogManager() {
        return this.getWizard().getCatalogManager();
    }

    public Trigger getTrigger() {
        return this.getWizard().getTrigger();
    }

    public String getTriggerName() {
        return this.getWizard().getTriggerName();
    }

    public Installation getInstallation() {
        return this.getWizard().getInstallation();
    }

    public Workspace getWorkspace() {
        return this.getWizard().getWorkspace();
    }

    public User getUser() {
        return this.getWizard().getUser();
    }

    public SetupTaskPerformer getPerformer() {
        return this.getWizard().getPerformer();
    }

    public void setPerformer(SetupTaskPerformer performer) {
        this.getWizard().setPerformer(performer);
    }

    protected final SetupTaskPerformer createPerformer(SetupPrompter prompter, boolean fullPrompt) throws Exception {
        User originalUser = this.getUser();
        URI uri = originalUser.eResource().getURI();
        User user = (User)EcoreUtil.copy((EObject)originalUser);
        Resource userResource = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        userResource.getContents().add((Object)user);
        Trigger trigger = this.getTrigger();
        Installation installation = this.getInstallation();
        Workspace workspace = this.getWorkspace();
        URIConverter uriConverter = this.getResourceSet().getURIConverter();
        SetupContext context = SetupContext.create((Installation)installation, (Workspace)workspace, (User)user);
        return SetupTaskPerformer.create((URIConverter)uriConverter, (SetupPrompter)prompter, (Trigger)trigger, (SetupContext)context, (boolean)fullPrompt);
    }

    public WizardFinisher getWizardFinisher() {
        return null;
    }

    public boolean performCancel() {
        return true;
    }

    public void sendStats(boolean success) {
    }

    protected void handleInactivity(Display display, boolean inactive) {
    }

    public void enterPage(boolean forward) {
    }

    public void leavePage(boolean forward) {
    }

    public final void gotoNextPage() {
        IWizardPage page = this.getNextPage();
        this.gotoPage("nextPressed", page);
    }

    public final void gotoPreviousPage() {
        IWizardPage page = this.getPreviousPage();
        this.gotoPage("backPressed", page);
    }

    private void gotoPage(String methodName, IWizardPage page) {
        IWizardContainer container = this.getContainer();
        if (container instanceof WizardDialog) {
            try {
                ReflectUtil.invokeMethod((String)methodName, (Object)container);
                return;
            }
            catch (Throwable throwable) {}
        }
        container.showPage(page);
    }

    public final void createControl(Composite parent) {
        GridLayout gridLayout = UIUtil.createGridLayout((int)1);
        gridLayout.marginWidth = 5;
        Composite pageControl = new Composite(parent, 0);
        pageControl.setLayout((Layout)gridLayout);
        super.setControl((Control)pageControl);
        this.setPageComplete(false);
        Composite uiContainer = new Composite(pageControl, 0);
        uiContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        uiContainer.setLayout((Layout)UIUtil.createGridLayout((int)1));
        Point sizeHint = this.getSizeHint();
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = sizeHint.x;
        layoutData.heightHint = sizeHint.y;
        Control ui = this.createUI(uiContainer);
        ui.setLayoutData((Object)layoutData);
        ButtonBar buttonBar = new ButtonBar(pageControl){

            protected IDialogSettings getDialogSettings() {
                return SetupWizardPage.this.getDialogSettings();
            }
        };
        this.createCheckButtons(buttonBar);
        this.createFooter(pageControl);
        parent.layout(true, true);
    }

    protected void createFooter(Composite parent) {
    }

    protected void createCheckButtons(ButtonBar buttonBar) {
    }

    protected final void setControl(Control newControl) {
        throw new UnsupportedOperationException();
    }

    protected Point getSizeHint() {
        return new Point(800, 500);
    }

    protected abstract Control createUI(Composite var1);

    protected final void addHelpCallout(Control control, int number) {
        IWizardContainer container = this.getContainer();
        if (container instanceof OomphWizardDialog) {
            OomphWizardDialog dialog = (OomphWizardDialog)container;
            dialog.getHelpSupport().addHelpCallout(control, number);
        }
    }

    protected void setButtonState(int buttonID, boolean enabled) {
        try {
            IWizardContainer container = this.getContainer();
            Method method = ReflectUtil.getMethod(container.getClass(), (String)"getButton", (Class[])new Class[]{Integer.TYPE});
            method.setAccessible(true);
            Button button = (Button)method.invoke((Object)container, buttonID);
            button.setEnabled(enabled);
        }
        catch (Throwable throwable) {}
    }

    public static interface WizardFinisher {
        public boolean performFinish();
    }
}

