/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core.listeners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.core.RootAnalyzer;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.TargletContainerEvent;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.core.listeners.FileUpdater;
import org.eclipse.oomph.targlets.internal.core.listeners.WorkspaceUpdateListener;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetDefinitionGenerator
extends WorkspaceUpdateListener {
    public static final String ANNOTATION = "http:/www.eclipse.org/oomph/targlets/TargetDefinitionGenerator";
    public static final String ANNOTATION_NAME = "name";
    public static final String ANNOTATION_LOCATION = "location";
    public static final String ANNOTATION_PREFERRED_REPOSITORIES = "preferredRepositories";
    public static final String ANNOTATION_GENERATE_IMPLICIT_UNITS = "generateImplicitUnits";
    public static final String ANNOTATION_GENERATE_VERSIONS = "generateVersions";
    public static final String ANNOTATION_INCLUDE_ALL_PLATFORMS = "includeAllPlatforms";
    public static final String ANNOTATION_INCLUDE_CONFIGURE_PHASE = "includeConfigurePhase";
    public static final String ANNOTATION_INCLUDE_MODE = "includeMode";
    public static final String ANNOTATION_INCLUDE_SOURCE = "includeSource";
    public static final String ANNOTATION_EXTRA_UNITS = "extraUnits";
    private static final Pattern SEQUENCE_NUMBER_PATTERN = Pattern.compile("sequenceNumber=\"([0-9]+)\"");
    private static final String TRUE = Boolean.TRUE.toString();

    @Override
    protected void handleTargletContainerEvent(TargletContainerEvent.ProfileUpdateSucceededEvent profileUpdateSucceededEvent, TargletContainerEvent.WorkspaceUpdateFinishedEvent workspaceUpdateFinishedEvent, IProgressMonitor monitor) throws Exception {
        ITargletContainer targletContainer = profileUpdateSucceededEvent.getSource();
        for (Targlet targlet : targletContainer.getTarglets()) {
            Annotation annotation = targlet.getAnnotation(ANNOTATION);
            if (annotation == null) continue;
            Profile profile = profileUpdateSucceededEvent.getProfile();
            IInstallableUnit artificialRoot = profileUpdateSucceededEvent.getArtificialRoot();
            List<IMetadataRepository> metadataRepositories = profileUpdateSucceededEvent.getMetadataRepositories();
            TargetDefinitionGenerator.generateTargetDefinition(targlet, annotation, profile, artificialRoot, metadataRepositories, monitor);
        }
    }

    private static void generateTargetDefinition(Targlet targlet, Annotation annotation, Profile profile, IInstallableUnit artificialRoot, List<IMetadataRepository> metadataRepositories, final IProgressMonitor monitor) throws Exception {
        monitor.setTaskName("Checking for generated target definition updates");
        EMap details = annotation.getDetails();
        String targletName = (String)details.get((Object)ANNOTATION_NAME);
        final String name = StringUtil.isEmpty((String)targletName) ? "Generated from " + targlet.getName() : targletName;
        String location = (String)details.get((Object)ANNOTATION_LOCATION);
        if (StringUtil.isEmpty((String)location)) {
            location = File.createTempFile("tmp-", ".target").getAbsolutePath();
            TargletsCorePlugin.INSTANCE.log("Generating target definition for targlet " + targlet.getName() + " to " + location);
        }
        File targetDefinition = new File(location);
        Set<IVersionedId> extraUnits = TargetDefinitionGenerator.getExtraUnits(annotation);
        List<String> preferredURLs = Arrays.asList(TargetDefinitionGenerator.getAnnotationDetail(annotation, ANNOTATION_PREFERRED_REPOSITORIES, "").split(","));
        boolean generateImplicitUnits = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_GENERATE_IMPLICIT_UNITS, false);
        final boolean versions = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_GENERATE_VERSIONS, false);
        final boolean includeAllPlatforms = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_INCLUDE_ALL_PLATFORMS, targlet.isIncludeAllPlatforms());
        final boolean includeConfigurePhase = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_INCLUDE_CONFIGURE_PHASE, true);
        final String includeMode = TargetDefinitionGenerator.getAnnotationDetail(annotation, ANNOTATION_INCLUDE_MODE, targlet.isIncludeAllRequirements() ? "planner" : "slicer");
        final boolean includeSource = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_INCLUDE_SOURCE, targlet.isIncludeSources());
        final Map<IMetadataRepository, Set<IInstallableUnit>> repositoryIUs = TargetDefinitionGenerator.analyzeRepositories(targlet, profile, artificialRoot, metadataRepositories, extraUnits, preferredURLs, generateImplicitUnits, monitor);
        new FileUpdater(){
            private int sequenceNumber;

            protected String createNewContents(String oldContents, String encoding, String nl) {
                Matcher matcher;
                if (oldContents != null && (matcher = SEQUENCE_NUMBER_PATTERN.matcher(oldContents)).find()) {
                    this.sequenceNumber = Integer.parseInt(matcher.group(1));
                }
                StringBuilder builder = new StringBuilder();
                builder.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\" standalone=\"no\"?>");
                builder.append(nl);
                builder.append("<?pde version=\"3.8\"?>");
                builder.append(nl);
                builder.append("<target name=\"" + name + "\" sequenceNumber=\"" + this.sequenceNumber + "\">");
                builder.append(nl);
                builder.append("  <locations>");
                builder.append(nl);
                for (Map.Entry entry : repositoryIUs.entrySet()) {
                    IMetadataRepository repository = (IMetadataRepository)entry.getKey();
                    Set set = (Set)entry.getValue();
                    ArrayList list = new ArrayList(set);
                    if (list.isEmpty()) continue;
                    builder.append("    <location includeAllPlatforms=\"" + includeAllPlatforms + "\" includeConfigurePhase=\"" + includeConfigurePhase + "\" includeMode=\"" + includeMode + "\" includeSource=\"" + includeSource + "\" type=\"InstallableUnit\">");
                    builder.append(nl);
                    LinkedHashSet<String> elements = new LinkedHashSet<String>();
                    Collections.sort(list);
                    for (IInstallableUnit iu : list) {
                        elements.add(TargetDefinitionGenerator.formatElement(iu, versions));
                    }
                    for (String element : elements) {
                        builder.append("      ");
                        builder.append(element);
                        builder.append(nl);
                    }
                    builder.append("      <repository location=\"" + repository.getLocation() + "\"/>");
                    builder.append(nl);
                    builder.append("    </location>");
                    builder.append(nl);
                }
                builder.append("  </locations>");
                builder.append(nl);
                builder.append("</target>");
                builder.append(nl);
                return builder.toString();
            }

            protected void setContents(URI uri, String encoding, String contents) throws IOException {
                monitor.subTask("Updating " + (uri.isPlatformResource() ? uri.toPlatformString(true) : uri.toFileString()));
                contents = contents.replace("sequenceNumber=\"" + this.sequenceNumber + "\"", "sequenceNumber=\"" + (this.sequenceNumber + 1) + "\"");
                super.setContents(uri, encoding, contents);
            }
        }.update(targetDefinition);
    }

    private static boolean isAnnotationDetail(Annotation annotation, String key, boolean defaultValue) {
        String detail = TargetDefinitionGenerator.getAnnotationDetail(annotation, key, Boolean.toString(defaultValue));
        return TRUE.equalsIgnoreCase(detail);
    }

    private static String getAnnotationDetail(Annotation annotation, String key, String defaultValue) {
        String value = (String)annotation.getDetails().get((Object)key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static Set<IVersionedId> getExtraUnits(Annotation annotation) {
        HashSet<IVersionedId> extraUnits = new HashSet<IVersionedId>();
        String values = (String)annotation.getDetails().get((Object)ANNOTATION_EXTRA_UNITS);
        if (!StringUtil.isEmpty((String)values)) {
            String[] stringArray = values.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!StringUtil.isEmpty((String)value)) {
                    int pos = value.lastIndexOf(95);
                    String id = pos == -1 ? value : value.substring(0, pos);
                    Version version = pos == -1 ? Version.emptyVersion : Version.create((String)value.substring(pos + 1));
                    extraUnits.add((IVersionedId)new VersionedId(id, version));
                }
                ++n2;
            }
        }
        return extraUnits;
    }

    private static String formatElement(IInstallableUnit iu, boolean withVersion) {
        Version version = iu.getVersion();
        if (!withVersion || version == null) {
            version = Version.emptyVersion;
        }
        return "<unit id=\"" + iu.getId() + "\" version=\"" + version + "\"/>";
    }

    private static Map<IMetadataRepository, Set<IInstallableUnit>> analyzeRepositories(Targlet targlet, Profile profile, IInstallableUnit artificialRoot, List<IMetadataRepository> metadataRepositories, Set<IVersionedId> extraUnits, List<String> preferredURLs, boolean generateImplicitUnits, IProgressMonitor monitor) {
        Set<IRequiredCapability> rootRequirements = TargetDefinitionGenerator.getRootRequirements(targlet, artificialRoot);
        HashSet<IInstallableUnit> resolvedIUs = new HashSet<IInstallableUnit>();
        for (IRequiredCapability requirement : rootRequirements) {
            TargetDefinitionGenerator.resolveRequirement(requirement, (IQueryable<IInstallableUnit>)profile, resolvedIUs);
        }
        Map<String, IMetadataRepository> queriables = TargetDefinitionGenerator.sortMetadataRepositories(targlet, metadataRepositories, preferredURLs, monitor);
        Map<IMetadataRepository, Set<IInstallableUnit>> result = TargetDefinitionGenerator.assignUnits(queriables, extraUnits, resolvedIUs);
        if (!generateImplicitUnits) {
            RootAnalyzer.removeImplicitUnits(result, (IProgressMonitor)monitor);
        }
        return result;
    }

    private static Set<IRequiredCapability> getRootRequirements(Targlet targlet, IInstallableUnit artificialRoot) {
        String id;
        HashMap profileRequirements = new HashMap();
        for (IRequirement profileRequirement : artificialRoot.getRequirements()) {
            if (!(profileRequirement instanceof IRequiredCapability)) continue;
            IRequiredCapability requiredCapability = (IRequiredCapability)profileRequirement;
            id = String.valueOf(requiredCapability.getNamespace()) + "/" + requiredCapability.getName();
            CollectionUtil.add(profileRequirements, (Object)id, (Object)requiredCapability);
        }
        HashSet<IRequiredCapability> queue = new HashSet<IRequiredCapability>();
        for (Requirement targletRequirement : targlet.getRequirements()) {
            id = String.valueOf(targletRequirement.getNamespace()) + "/" + targletRequirement.getName();
            Set set = (Set)profileRequirements.get(id);
            if (set == null) continue;
            queue.addAll(set);
        }
        return queue;
    }

    private static void resolveRequirement(IRequiredCapability requirement, IQueryable<IInstallableUnit> queryable, Set<IInstallableUnit> result) {
        for (IInstallableUnit iu : queryable.query(QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0]), null)) {
            String id = iu.getId();
            if (id.endsWith(".source") || id.endsWith(".source.feature.group") || "true".equals(iu.getProperty("org.eclipse.oomph.targlet.source")) || !"true".equals(iu.getProperty("org.eclipse.oomph.targlet.workspace")) && !result.add(iu)) continue;
            for (IRequirement iuRequirement : iu.getRequirements()) {
                if (!(iuRequirement instanceof IRequiredCapability)) continue;
                TargetDefinitionGenerator.resolveRequirement((IRequiredCapability)iuRequirement, queryable, result);
            }
        }
    }

    private static Map<String, IMetadataRepository> sortMetadataRepositories(Targlet targlet, List<IMetadataRepository> metadataRepositories, List<String> preferredURLs, IProgressMonitor monitor) {
        String url;
        LinkedHashMap<String, IMetadataRepository> queriables = new LinkedHashMap<String, IMetadataRepository>();
        for (String urlPrefix : preferredURLs) {
            for (IMetadataRepository metadataRepository : metadataRepositories) {
                String url2 = metadataRepository.getLocation().toString();
                if (queriables.containsKey(url2) || !url2.startsWith(urlPrefix)) continue;
                queriables.put(url2, metadataRepository);
            }
        }
        for (Repository repository : targlet.getActiveRepositories()) {
            IMetadataRepository metadataRepository;
            TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
            url = repository.getURL();
            if (queriables.containsKey(url) || (metadataRepository = TargetDefinitionGenerator.getMetadataRepository(url, metadataRepositories)) == null) continue;
            queriables.put(url, metadataRepository);
        }
        for (IMetadataRepository metadataRepository : metadataRepositories) {
            url = metadataRepository.getLocation().toString();
            if (queriables.containsKey(url)) continue;
            queriables.put(url, metadataRepository);
        }
        return queriables;
    }

    private static IMetadataRepository getMetadataRepository(String url, List<IMetadataRepository> metadataRepositories) {
        for (IMetadataRepository metadataRepository : metadataRepositories) {
            if (!metadataRepository.getLocation().toString().equals(url)) continue;
            return metadataRepository;
        }
        return null;
    }

    private static Map<IMetadataRepository, Set<IInstallableUnit>> assignUnits(Map<String, IMetadataRepository> queriables, Set<IVersionedId> extraUnits, Set<IInstallableUnit> resolvedIUs) {
        LinkedHashMap<IMetadataRepository, Set<IInstallableUnit>> result = new LinkedHashMap<IMetadataRepository, Set<IInstallableUnit>>();
        for (String url : queriables.keySet()) {
            IMetadataRepository metadataRepository = queriables.get(url);
            Set ius = CollectionUtil.getSet(result, (Object)metadataRepository);
            Iterator<IVersionedId> it = extraUnits.iterator();
            while (it.hasNext()) {
                IVersionedId extraUnit = it.next();
                Iterator iterator = metadataRepository.query(QueryUtil.createIUQuery((IVersionedId)extraUnit), null).iterator();
                if (!iterator.hasNext()) continue;
                IInstallableUnit extraIU = (IInstallableUnit)iterator.next();
                ius.add(extraIU);
                it.remove();
            }
        }
        block2: for (IInstallableUnit iu : resolvedIUs) {
            for (IMetadataRepository metadataRepository : queriables.values()) {
                if (metadataRepository.query(QueryUtil.createIUQuery((IVersionedId)iu), null).isEmpty()) continue;
                CollectionUtil.add(result, (Object)metadataRepository, (Object)iu);
                continue block2;
            }
        }
        return result;
    }
}

