/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemBrowserContainerAdapter;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.internal.core.ECFPlugin;
import org.eclipse.ecf.provider.filetransfer.browse.MultiProtocolFileSystemBrowserAdapter;
import org.eclipse.ecf.provider.filetransfer.browse.MultiProtocolFileSystemBrowserAdapterFactory;
import org.eclipse.ecf.provider.filetransfer.retrieve.MultiProtocolRetrieveAdapter;
import org.eclipse.ecf.provider.filetransfer.retrieve.MultiProtocolRetrieveAdapterFactory;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.Messages;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public final class P2CorePlugin
extends OomphPlugin {
    public static final P2CorePlugin INSTANCE = new P2CorePlugin();
    private static Implementation plugin;

    public P2CorePlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static File getUserStateFolder(File userHome) {
        File folder = new File(userHome, ".eclipse/org.eclipse.oomph.p2");
        try {
            File oldFolder;
            if (!folder.exists() && (oldFolder = new File(String.valueOf(folder.getAbsolutePath()) + ".core")).isDirectory()) {
                IOUtil.copyTree((File)oldFolder, (File)folder);
                String message = NLS.bind((String)Messages.P2CorePlugin_OldFolder_message, (Object)folder.getName());
                IOUtil.writeFile((File)new File(oldFolder, "readme.txt"), (byte[])message.getBytes());
            }
        }
        catch (Exception ex) {
            INSTANCE.log(ex);
        }
        return folder;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            try {
                IContainer container = ContainerFactory.getDefault().createContainer();
                MultiProtocolFileSystemBrowserAdapterFactory browserAdapter = new MultiProtocolFileSystemBrowserAdapterFactory(){

                    protected Object getContainerAdapter(IContainer container, Class adapterType) {
                        if (adapterType.equals(IRemoteFileSystemBrowserContainerAdapter.class)) {
                            return new MultiProtocolFileSystemBrowserAdapter();
                        }
                        return null;
                    }
                };
                MultiProtocolRetrieveAdapterFactory retrieveAdapter = new MultiProtocolRetrieveAdapterFactory(){

                    protected Object getContainerAdapter(IContainer container, Class adapterType) {
                        if (adapterType.equals(IRetrieveFileTransferContainerAdapter.class)) {
                            return new MultiProtocolRetrieveAdapter();
                        }
                        return null;
                    }
                };
                AdapterManager adapterManager = (AdapterManager)ECFPlugin.getDefault().getAdapterManager();
                adapterManager.registerAdapters((IAdapterFactory)browserAdapter, container.getClass());
                adapterManager.registerAdapters((IAdapterFactory)retrieveAdapter, container.getClass());
                for (List list : adapterManager.getFactories().values()) {
                    if (list.remove(browserAdapter)) {
                        list.add(0, browserAdapter);
                    }
                    if (!list.remove(retrieveAdapter)) continue;
                    list.add(0, retrieveAdapter);
                }
            }
            catch (ContainerCreateException containerCreateException) {
                // empty catch block
            }
        }

        public void stop(BundleContext context) throws Exception {
            ((AgentManagerImpl)P2Util.getAgentManager()).dispose();
            super.stop(context);
        }
    }
}

