/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: Namespace.java,v 1.1 2007/03/18 08:10:11 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfweb;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.eodm.rdf.rdfbase.URIReference;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Namespace</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.Namespace#getNamespaceURIRef <em>namespaceURIRef</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getNamespace()
 * @model
 * @generated
 */
public interface Namespace extends EObject {
	/**
	 * Returns the value of the '<em><b>namespaceURIRef</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getNamespace <em>namespace</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Namespace URI Ref</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>namespaceURIRef</em>' reference.
	 * @see #setNamespaceURIRef(URIReference)
	 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getNamespace_NamespaceURIRef()
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference#getNamespace
	 * @model opposite="namespace" required="true"
	 * @generated
	 */
	URIReference getNamespaceURIRef();


} // Namespace
