/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: LocalName.java,v 1.1 2007/03/18 08:10:11 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfweb;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Local Name</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.LocalName#getName <em>name</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.LocalName#getUriRef <em>uriRef</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getLocalName()
 * @model
 * @generated
 */
public interface LocalName extends EObject {
	/**
	 * Returns the value of the '<em><b>name</b></em>' attribute.
	 * The default value is <code>""</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getLocalName_Name()
	 * @model default="" required="true"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfweb.LocalName#getName <em>name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>uriRef</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.URIReference}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getFragmentIdentifier <em>fragmentIdentifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Uri Ref</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>uriRef</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage#getLocalName_UriRef()
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference#getFragmentIdentifier
	 * @model type="org.eclipse.eodm.rdf.rdfbase.URIReference" opposite="fragmentIdentifier"
	 * @generated
	 */
	EList getUriRef();

} // LocalName
