/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFSPackage.java,v 1.2 2007/03/18 10:23:38 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfs.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSFactory
 * @model kind="package"
 * @generated
 */
public interface RDFSPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "rdfs";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///odm 2006-02-17/org/omg/odm/RDF/RDFS.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "odm 2006-02-17.org.omg.odm.RDF.RDFS";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	RDFSPackage eINSTANCE = org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfs.impl.RDFSClassImpl <em>RDFS Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfs.impl.RDFSClassImpl
	 * @see org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl#getRDFSClass()
	 * @generated
	 */
	int RDFS_CLASS = 0;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__RDF_SIS_DEFINED_BY = RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__RDF_SSEE_ALSO = RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__RD_FTYPE = RDFBasePackage.RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__RDF_SMEMBER = RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__NODE_ID = RDFBasePackage.RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__RDF_SCOMMENT = RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__RDF_SLABEL = RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__URI_REF = RDFBasePackage.RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__SUBJECT_STATEMENT = RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__RDF_SSUB_CLASS_OF = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__SUB_CLASS = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__PROPERTY_FOR_DOMAIN = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS__PROPERTY_FOR_RANGE = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 3;
	
	/**
	 * The feature id for the '<em><b>Typed Resource</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 */
	int RDFS_CLASS__TYPED_RESOURCE = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 4 ;
	

	/**
	 * The number of structural features of the the '<em>RDFS Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CLASS_FEATURE_COUNT = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfs.impl.RDFSDatatypeImpl <em>RDFS Datatype</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfs.impl.RDFSDatatypeImpl
	 * @see org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl#getRDFSDatatype()
	 * @generated
	 */
	int RDFS_DATATYPE = 1;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__RDF_SIS_DEFINED_BY = RDFS_CLASS__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__RDF_SSEE_ALSO = RDFS_CLASS__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__RD_FTYPE = RDFS_CLASS__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__RDF_SMEMBER = RDFS_CLASS__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__NODE_ID = RDFS_CLASS__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__RDF_SCOMMENT = RDFS_CLASS__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__RDF_SLABEL = RDFS_CLASS__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__URI_REF = RDFS_CLASS__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__SUBJECT_STATEMENT = RDFS_CLASS__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Ssub Class Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__RDF_SSUB_CLASS_OF = RDFS_CLASS__RDF_SSUB_CLASS_OF;

	/**
	 * The feature id for the '<em><b>Sub Class</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__SUB_CLASS = RDFS_CLASS__SUB_CLASS;

	/**
	 * The feature id for the '<em><b>Property For Domain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__PROPERTY_FOR_DOMAIN = RDFS_CLASS__PROPERTY_FOR_DOMAIN;

	/**
	 * The feature id for the '<em><b>Property For Range</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE__PROPERTY_FOR_RANGE = RDFS_CLASS__PROPERTY_FOR_RANGE;

	int RDFS_DATATYPE__TYPED_RESOURCE = RDFS_CLASS__TYPED_RESOURCE;
	
	/**
	 * The number of structural features of the the '<em>RDFS Datatype</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_DATATYPE_FEATURE_COUNT = RDFS_CLASS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.RDFListImpl <em>RDF List</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.RDFListImpl
	 * @see org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl#getRDFList()
	 * @generated
	 */
	int RDF_LIST = 2;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__RDF_SIS_DEFINED_BY = RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__RDF_SSEE_ALSO = RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__RD_FTYPE = RDFBasePackage.RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__RDF_SMEMBER = RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__NODE_ID = RDFBasePackage.RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__RDF_SCOMMENT = RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__RDF_SLABEL = RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__URI_REF = RDFBasePackage.RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__SUBJECT_STATEMENT = RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RD Ffirst</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__RD_FFIRST = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>RD Frest</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST__RD_FREST = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>RDF List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_LIST_FEATURE_COUNT = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.RDFSContainerImpl <em>RDFS Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.RDFSContainerImpl
	 * @see org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl#getRDFSContainer()
	 * @generated
	 */
	int RDFS_CONTAINER = 3;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER__RDF_SIS_DEFINED_BY = RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER__RDF_SSEE_ALSO = RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER__RD_FTYPE = RDFBasePackage.RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER__RDF_SMEMBER = RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER__NODE_ID = RDFBasePackage.RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER__RDF_SCOMMENT = RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER__RDF_SLABEL = RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER__URI_REF = RDFBasePackage.RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER__SUBJECT_STATEMENT = RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The number of structural features of the the '<em>RDFS Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_FEATURE_COUNT = RDFBasePackage.RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.RDFAltImpl <em>RDF Alt</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.RDFAltImpl
	 * @see org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl#getRDFAlt()
	 * @generated
	 */
	int RDF_ALT = 4;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_ALT__RDF_SIS_DEFINED_BY = RDFS_CONTAINER__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_ALT__RDF_SSEE_ALSO = RDFS_CONTAINER__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_ALT__RD_FTYPE = RDFS_CONTAINER__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_ALT__RDF_SMEMBER = RDFS_CONTAINER__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_ALT__NODE_ID = RDFS_CONTAINER__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_ALT__RDF_SCOMMENT = RDFS_CONTAINER__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_ALT__RDF_SLABEL = RDFS_CONTAINER__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_ALT__URI_REF = RDFS_CONTAINER__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_ALT__SUBJECT_STATEMENT = RDFS_CONTAINER__SUBJECT_STATEMENT;

	/**
	 * The number of structural features of the the '<em>RDF Alt</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_ALT_FEATURE_COUNT = RDFS_CONTAINER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.RDFBagImpl <em>RDF Bag</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.RDFBagImpl
	 * @see org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl#getRDFBag()
	 * @generated
	 */
	int RDF_BAG = 5;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_BAG__RDF_SIS_DEFINED_BY = RDFS_CONTAINER__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_BAG__RDF_SSEE_ALSO = RDFS_CONTAINER__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_BAG__RD_FTYPE = RDFS_CONTAINER__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_BAG__RDF_SMEMBER = RDFS_CONTAINER__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_BAG__NODE_ID = RDFS_CONTAINER__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_BAG__RDF_SCOMMENT = RDFS_CONTAINER__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_BAG__RDF_SLABEL = RDFS_CONTAINER__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_BAG__URI_REF = RDFS_CONTAINER__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_BAG__SUBJECT_STATEMENT = RDFS_CONTAINER__SUBJECT_STATEMENT;

	/**
	 * The number of structural features of the the '<em>RDF Bag</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_BAG_FEATURE_COUNT = RDFS_CONTAINER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.RDFSeqImpl <em>RDF Seq</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.RDFSeqImpl
	 * @see org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl#getRDFSeq()
	 * @generated
	 */
	int RDF_SEQ = 6;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_SEQ__RDF_SIS_DEFINED_BY = RDFS_CONTAINER__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_SEQ__RDF_SSEE_ALSO = RDFS_CONTAINER__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_SEQ__RD_FTYPE = RDFS_CONTAINER__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_SEQ__RDF_SMEMBER = RDFS_CONTAINER__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_SEQ__NODE_ID = RDFS_CONTAINER__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_SEQ__RDF_SCOMMENT = RDFS_CONTAINER__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_SEQ__RDF_SLABEL = RDFS_CONTAINER__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_SEQ__URI_REF = RDFS_CONTAINER__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_SEQ__SUBJECT_STATEMENT = RDFS_CONTAINER__SUBJECT_STATEMENT;

	/**
	 * The number of structural features of the the '<em>RDF Seq</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_SEQ_FEATURE_COUNT = RDFS_CONTAINER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.RDFSContainerMembershipPropertyImpl <em>RDFS Container Membership Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.RDFSContainerMembershipPropertyImpl
	 * @see org.eclipse.eodm.rdf.rdfs.impl.RDFSPackageImpl#getRDFSContainerMembershipProperty()
	 * @generated
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY = 7;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__RDF_SIS_DEFINED_BY = RDFBasePackage.RDF_PROPERTY__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__RDF_SSEE_ALSO = RDFBasePackage.RDF_PROPERTY__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__RD_FTYPE = RDFBasePackage.RDF_PROPERTY__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__RDF_SMEMBER = RDFBasePackage.RDF_PROPERTY__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__NODE_ID = RDFBasePackage.RDF_PROPERTY__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__RDF_SCOMMENT = RDFBasePackage.RDF_PROPERTY__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__RDF_SLABEL = RDFBasePackage.RDF_PROPERTY__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__URI_REF = RDFBasePackage.RDF_PROPERTY__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__SUBJECT_STATEMENT = RDFBasePackage.RDF_PROPERTY__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Sdomain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__RDF_SDOMAIN = RDFBasePackage.RDF_PROPERTY__RDF_SDOMAIN;

	/**
	 * The feature id for the '<em><b>RDF Srange</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__RDF_SRANGE = RDFBasePackage.RDF_PROPERTY__RDF_SRANGE;

	/**
	 * The feature id for the '<em><b>RDF Ssub Property Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__RDF_SSUB_PROPERTY_OF = RDFBasePackage.RDF_PROPERTY__RDF_SSUB_PROPERTY_OF;

	/**
	 * The feature id for the '<em><b>Sub Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY__SUB_PROPERTY = RDFBasePackage.RDF_PROPERTY__SUB_PROPERTY;

	/**
	 * The number of structural features of the the '<em>RDFS Container Membership Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_CONTAINER_MEMBERSHIP_PROPERTY_FEATURE_COUNT = RDFBasePackage.RDF_PROPERTY_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass <em>RDFS Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDFS Class</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass
	 * @generated
	 */
	EClass getRDFSClass();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getRDFSsubClassOf <em>RDF Ssub Class Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>RDF Ssub Class Of</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass#getRDFSsubClassOf()
	 * @see #getRDFSClass()
	 * @generated
	 */
	EReference getRDFSClass_RDFSsubClassOf();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getSubClass <em>Sub Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Sub Class</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass#getSubClass()
	 * @see #getRDFSClass()
	 * @generated
	 */
	EReference getRDFSClass_SubClass();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getPropertyForDomain <em>Property For Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Property For Domain</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass#getPropertyForDomain()
	 * @see #getRDFSClass()
	 * @generated
	 */
	EReference getRDFSClass_PropertyForDomain();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getPropertyForRange <em>Property For Range</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Property For Range</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass#getPropertyForRange()
	 * @see #getRDFSClass()
	 * @generated
	 */
	EReference getRDFSClass_PropertyForRange();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getTypedResource <em>Typed Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Typed Resource</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass#getTypedResource()
	 * @see #getRDFSClass()
	 */	
	EReference getRDFSClass_TypedResource();
	
	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfs.RDFSDatatype <em>RDFS Datatype</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDFS Datatype</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSDatatype
	 * @generated
	 */
	EClass getRDFSDatatype();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfs.RDFList <em>RDF List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDF List</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFList
	 * @generated
	 */
	EClass getRDFList();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfs.RDFList#getRDFfirst <em>RD Ffirst</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>RD Ffirst</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFList#getRDFfirst()
	 * @see #getRDFList()
	 * @generated
	 */
	EReference getRDFList_RDFfirst();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfs.RDFList#getRDFrest <em>RD Frest</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>RD Frest</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFList#getRDFrest()
	 * @see #getRDFList()
	 * @generated
	 */
	EReference getRDFList_RDFrest();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfs.RDFSContainer <em>RDFS Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDFS Container</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSContainer
	 * @generated
	 */
	EClass getRDFSContainer();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfs.RDFAlt <em>RDF Alt</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDF Alt</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFAlt
	 * @generated
	 */
	EClass getRDFAlt();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfs.RDFBag <em>RDF Bag</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDF Bag</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFBag
	 * @generated
	 */
	EClass getRDFBag();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfs.RDFSeq <em>RDF Seq</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDF Seq</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSeq
	 * @generated
	 */
	EClass getRDFSeq();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfs.RDFSContainerMembershipProperty <em>RDFS Container Membership Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDFS Container Membership Property</em>'.
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSContainerMembershipProperty
	 * @generated
	 */
	EClass getRDFSContainerMembershipProperty();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	RDFSFactory getrdfsFactory();

} //RDFSPackage
