/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFList.java,v 1.1 2007/03/18 08:10:13 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfs;

import org.eclipse.eodm.rdf.rdfbase.RDFSResource;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>RDF List</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfs.RDFList#getRDFfirst <em>RDFfirst</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfs.RDFList#getRDFrest <em>RDFrest</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage#getRDFList()
 * @model
 * @generated
 */
public interface RDFList extends RDFSResource {
	/**
	 * Returns the value of the '<em><b>RDFfirst</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RD Ffirst</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFfirst</em>' reference.
	 * @see #setRDFfirst(RDFSResource)
	 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage#getRDFList_RDFfirst()
	 * @model
	 * @generated
	 */
	RDFSResource getRDFfirst();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfs.RDFList#getRDFfirst <em>RDFfirst</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>RDFfirst</em>' reference.
	 * @see #getRDFfirst()
	 * @generated
	 */
	void setRDFfirst(RDFSResource value);

	/**
	 * Returns the value of the '<em><b>RDFrest</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RD Frest</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFrest</em>' reference.
	 * @see #setRDFrest(RDFList)
	 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage#getRDFList_RDFrest()
	 * @model
	 * @generated
	 */
	RDFList getRDFrest();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfs.RDFList#getRDFrest <em>RDFrest</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>RDFrest</em>' reference.
	 * @see #getRDFrest()
	 * @generated
	 */
	void setRDFrest(RDFList value);

} // RDFList
