/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: Universe.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Universe</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.Universe#getOntology <em>ontology</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getUniverse()
 * @model abstract="true"
 * @generated
 */
public interface Universe extends EObject {
	/**
	 * Returns the value of the '<em><b>ontology</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlUniverse <em>owlUniverse</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ontology</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>ontology</em>' reference.
	 * @see #setOntology(OWLOntology)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getUniverse_Ontology()
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlUniverse
	 * @model opposite="owlUniverse" required="true"
	 * @generated
	 */
	OWLOntology getOntology();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.Universe#getOntology <em>ontology</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>ontology</em>' reference.
	 * @see #getOntology()
	 * @generated
	 */
	void setOntology(OWLOntology value);

} // Universe
