/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLGraph.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase;

import org.eclipse.emf.common.util.EList;

import org.eclipse.eodm.rdf.rdfbase.RDFGraph;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>OWL Graph</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLGraph#getGraphontology <em>graphontology</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLGraph#getOwlGraphStatement <em>owlGraphStatement</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLGraph()
 * @model
 * @generated
 */
public interface OWLGraph extends RDFGraph {
	/**
	 * Returns the value of the '<em><b>graphontology</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.OWLOntology}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlGraph <em>owlGraph</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Graphontology</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>graphontology</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLGraph_Graphontology()
	 * @see org.eclipse.eodm.owl.owlbase.OWLOntology#getOwlGraph
	 * @model type="org.eclipse.eodm.owl.owlbase.OWLOntology" opposite="owlGraph"
	 * @generated
	 */
	EList getGraphontology();

	/**
	 * Returns the value of the '<em><b>owlGraphStatement</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.Statement}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owl Graph Statement</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>owlGraphStatement</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLGraph_OwlGraphStatement()
	 * @model type="org.eclipse.eodm.owl.owlbase.Statement" required="true"
	 * @generated
	 */
	EList getOwlGraphStatement();

} // OWLGraph
