/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: ErrorHandler.java,v 1.2 2007/03/18 08:39:03 lzhang Exp $
 */
package org.eclipse.eodm.rdf.resource.parser;

/**
 * The error handler.
 */
public interface ErrorHandler {
    /**
     * deal with error information from the parser
     * 
     * @param msg
     *            errors thrown by the parser
     */
    void error(String msg);

    /**
     * deal with warning information from the parser
     * 
     * @param msg
     *            warnings thrown by the parser
     */
    void warning(String msg);

    /**
     * deal with fatal information from the parser
     * 
     * @param msg
     *            fatal errors thrown by the parser
     */
    void fatal(String msg);
}