/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: OntologyTripleAnalyzer.java,v 1.1 2007/03/18 09:07:04 lzhang Exp $
 */

package org.eclipse.eodm.owl.resource.parser.impl;

import org.eclipse.eodm.owl.resource.parser.OWLDocument;
import org.eclipse.eodm.owl.resource.parser.TripleAnalyzer;
import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;
import org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement;
import org.eclipse.eodm.rdf.resource.parser.element.RDFValue;
import org.eclipse.eodm.rdf.resource.parser.element.URIReference;
import org.eclipse.eodm.vocabulary.OWL;
import org.eclipse.eodm.vocabulary.RDF;

/**
 * 
 * OntologyTripleAnalyzer Get ontology import information to form import closure
 */
public class OntologyTripleAnalyzer implements TripleAnalyzer {
    /*
     * The OWL document to be analyzed
     */
    private OWLDocument document;

    /**
     * Initialize an OWL document
     * 
     * @param doc
     *            The OWL document to be analyzed
     */
    public OntologyTripleAnalyzer(OWLDocument doc) {
        document = doc;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.eodm.owl.resource.parser.TripleAnalyzer#handleNamespace(java.lang.String,
     *      java.lang.String)
     */
    public NamespaceDefinition handleNamespace(String name, String uri) {
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.eodm.owl.resource.parser.TripleAnalyzer#analyseStatement(org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement,
     *      org.eclipse.eodm.rdf.resource.parser.element.URIReference,
     *      org.eclipse.eodm.rdf.resource.parser.element.RDFValue)
     */
    public void analyseStatement(RDFResourceElement subject,
            URIReference predicate, RDFValue object) {
        if (predicate.getFullURI().equals(OWL.IMPORTS_URI))
            document.addImportOntologyURIs(((RDFResourceElement) object)
                    .getFullURI());
        else if (object instanceof RDFResourceElement
                 && ((RDFResourceElement) object).getFullURI().equals(
                         OWL.ONTOLOGY_URI)
                 && predicate.getFullURI().equals(RDF.P_TYPE_STR))
            if (document.getPublicURI() == null)
                document.setPublicURI(subject.getFullURI());
    }

}
