/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.linuxtools.docker.core.IDockerBlkioWeightDevice;
import org.mandas.docker.client.messages.HostConfig;

public class DockerBlkioWeightDevice
implements IDockerBlkioWeightDevice {
    private final String path;
    private final Integer weight;

    public DockerBlkioWeightDevice(HostConfig.BlkioWeightDevice blkioWeightDevice) {
        this.path = blkioWeightDevice.path();
        this.weight = blkioWeightDevice.weight();
    }

    private DockerBlkioWeightDevice(Builder builder) {
        this.path = builder.path;
        this.weight = builder.weight;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Integer weight() {
        return this.weight;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String path;
        private Integer weight;

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public IDockerBlkioWeightDevice build() {
            return new DockerBlkioWeightDevice(this);
        }
    }
}

