/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.util.ArrayList;

public class SystemTapCommandGenerator {
    private static boolean needsToSendCommand;
    private static boolean needsArguments;
    private static String arguments;
    private static String scriptPath;
    private static String flags;
    private static String binaryPath;
    private static String binaryArguments;
    private static String command;

    public static String generateCommand(String scrPath, String binPath, String opts, boolean needBinary, boolean needsArgs, String arg, String binArguments, String cmdTarget) {
        needsToSendCommand = needBinary;
        needsArguments = needsArgs;
        binaryPath = binPath;
        scriptPath = scrPath;
        arguments = "--runtime=dyninst " + arg;
        flags = opts;
        binaryArguments = binArguments;
        command = cmdTarget;
        String[] script = SystemTapCommandGenerator.buildScript();
        Object cmd = "";
        for (int i = 0; i < script.length - 1; ++i) {
            cmd = (String)cmd + script[i] + " ";
        }
        cmd = (String)cmd + script[script.length - 1];
        return cmd;
    }

    private static String[] buildScript() {
        String[] script;
        ArrayList<Object> cmdList = new ArrayList<Object>();
        if (flags.length() > 0) {
            cmdList.add(flags);
        }
        if (needsToSendCommand) {
            if (binaryArguments.length() < 1) {
                cmdList.add("-c '" + binaryPath + "'");
            } else {
                cmdList.add("-c \"" + binaryPath + " " + binaryArguments + "\"");
            }
        }
        if (needsArguments) {
            script = new String[cmdList.size() + 3];
            script[script.length - 2] = scriptPath;
            script[script.length - 1] = arguments;
        } else {
            script = new String[cmdList.size() + 2];
            script[script.length - 1] = scriptPath;
        }
        script[0] = command;
        for (int i = 0; i < cmdList.size(); ++i) {
            script[i + 1] = cmdList.get(i) != null ? (String)cmdList.get(i) : "";
        }
        return script;
    }

    static {
        binaryPath = null;
    }
}

