/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenFileHandler
extends AbstractHandler {
    private boolean successful;
    private boolean cancelled;
    private IWorkbenchWindow window = null;

    public void executeOnFile(File file) {
        if (this.window == null) {
            this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if (file != null && file.exists() && file.getName().endsWith(".stp")) {
            this.runActions(file);
        }
    }

    public Object execute(ExecutionEvent event) {
        File file;
        if (this.window == null) {
            this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if ((file = this.queryFile()) != null) {
            this.runActions(file);
        }
        return null;
    }

    private void runActions(File file) {
        this.successful = false;
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
        IWorkbenchPage page = this.window.getActivePage();
        try {
            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            this.successful = true;
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.window.getShell(), (String)Localization.getString("OpenFileHandler.Problem"), (String)Localization.getString("OpenFileHandler.ProblemMessage"), (IStatus)Status.error((String)e.getMessage(), (Throwable)e));
        }
    }

    protected int dialogStyle() {
        return 4096;
    }

    protected String dialogName() {
        return Localization.getString("OpenFileHandler.OpenFile");
    }

    protected File queryFile() {
        FileDialog dialog = new FileDialog(this.window.getShell(), this.dialogStyle());
        dialog.setFilterExtensions(new String[]{"*.stp"});
        dialog.setText(this.dialogName());
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            this.cancelled = false;
            return new File(path);
        }
        this.cancelled = true;
        return null;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public boolean isSuccessful() {
        return this.successful;
    }
}

