/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.parser;

import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.linuxtools.internal.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.internal.gprof.symbolManager.CallGraphArc;
import org.eclipse.linuxtools.internal.gprof.symbolManager.CallGraphNode;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistRoot;

public class CallGraphDecoder {
    protected final GmonDecoder decoder;
    private final Map<IBinaryParser.ISymbol, CallGraphNode> nodes = new HashMap<IBinaryParser.ISymbol, CallGraphNode>();

    public CallGraphDecoder(GmonDecoder decoder) {
        this.decoder = decoder;
    }

    public void decodeCallGraphRecord(DataInput stream, boolean bsdFormat) throws IOException {
        long from_pc = this.readAddress(stream);
        long self_pc = this.readAddress(stream);
        int count = bsdFormat ? (int)this.readAddress(stream) : stream.readInt();
        IBinaryParser.IBinaryObject program = this.decoder.getProgram();
        IAddressFactory addressFactory = program.getAddressFactory();
        IAddress parentAddress = addressFactory.createAddress(Long.toString(from_pc));
        IBinaryParser.ISymbol parentSymbol = program.getSymbol(parentAddress);
        IAddress childAddress = addressFactory.createAddress(Long.toString(self_pc));
        IBinaryParser.ISymbol childSymbol = program.getSymbol(childAddress);
        if (childSymbol == null || parentSymbol == null) {
            return;
        }
        this.addCallArc(parentSymbol, parentAddress, childSymbol, count);
    }

    protected long readAddress(DataInput stream) throws IOException {
        return (long)stream.readInt() & 0xFFFFFFFFL;
    }

    private void addCallArc(IBinaryParser.ISymbol parent, IAddress parentAddress, IBinaryParser.ISymbol child, int count) {
        CallGraphArc arc;
        CallGraphNode parentNode = this.nodes.get(parent);
        CallGraphNode childNode = this.nodes.get(child);
        if (parentNode == null) {
            parentNode = new CallGraphNode(parent);
            this.nodes.put(parent, parentNode);
        }
        if (childNode == null) {
            childNode = new CallGraphNode(child);
            this.nodes.put(child, childNode);
        }
        if ((arc = parentNode.getOutputArc(childNode)) == null) {
            arc = new CallGraphArc(parentNode, parentAddress, childNode, count, this.decoder.getProgram(), this.decoder.getProject());
            parentNode.getChildren().add(arc);
            childNode.getParents().add(arc);
        } else {
            arc.setCount(arc.getCount() + count);
        }
    }

    void populate(HistRoot rootNode) {
        for (CallGraphNode callGraphNode : this.nodes.values()) {
            rootNode.addCallGraphNode(callGraphNode);
        }
    }
}

