/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.man.help;

import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.osgi.framework.FrameworkUtil;

public class PageTopic
implements ITopic,
Comparable<PageTopic> {
    private final String sectionId;
    private final String pageId;

    public PageTopic(String sectionId, String pageId) {
        this.sectionId = sectionId;
        this.pageId = pageId;
    }

    public boolean isEnabled(IEvaluationContext context) {
        return true;
    }

    public IUAElement[] getChildren() {
        return this.getSubtopics();
    }

    public String getHref() {
        String pageUrl = this.pageId;
        pageUrl = pageUrl.replaceAll("\\[", "LBRACKET");
        pageUrl = pageUrl.replaceAll("\\]", "RBRACKET");
        return "/" + FrameworkUtil.getBundle(this.getClass()).getSymbolicName() + "/" + this.sectionId + "/" + pageUrl + ".html";
    }

    public String getLabel() {
        return this.pageId;
    }

    public ITopic[] getSubtopics() {
        return new ITopic[0];
    }

    @Override
    public int compareTo(PageTopic o) {
        return this.pageId.compareTo(o.pageId);
    }
}

