/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.kafka.admin.ConfigSynonym;
import java.util.Base64;
import java.util.Map;
import org.apache.kafka.clients.admin.ConfigEntry;

public class ConfigSynonymConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, ConfigSynonym obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setName((String)member.getValue());
                    break;
                }
                case "source": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSource(ConfigEntry.ConfigSource.valueOf((String)member.getValue()));
                    break;
                }
                case "value": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setValue((String)member.getValue());
                }
            }
        }
    }

    static void toJson(ConfigSynonym obj, JsonObject json) {
        ConfigSynonymConverter.toJson(obj, json.getMap());
    }

    static void toJson(ConfigSynonym obj, Map<String, Object> json) {
        if (obj.getName() != null) {
            json.put("name", obj.getName());
        }
        if (obj.getSource() != null) {
            json.put("source", obj.getSource().name());
        }
        if (obj.getValue() != null) {
            json.put("value", obj.getValue());
        }
    }
}

