/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.tuples;

import io.smallrye.mutiny.tuples.Tuple;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class Tuple2<L, R>
implements Tuple {
    final L item1;
    final R item2;

    protected Tuple2(L left, R right) {
        this.item1 = left;
        this.item2 = right;
    }

    public static <L, R> Tuple2<L, R> of(L l, R r) {
        return new Tuple2<L, R>(l, r);
    }

    public L getItem1() {
        return this.item1;
    }

    public R getItem2() {
        return this.item2;
    }

    public <T> Tuple2<T, R> mapItem1(Function<L, T> mapper) {
        return Tuple2.of(mapper.apply(this.item1), this.item2);
    }

    public <T> Tuple2<L, T> mapItem2(Function<R, T> mapper) {
        return Tuple2.of(this.item1, mapper.apply(this.item2));
    }

    @Override
    public Object nth(int index) {
        this.assertIndexInBounds(index);
        if (index == 0) {
            return this.item1;
        }
        return this.item2;
    }

    protected void assertIndexInBounds(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot retrieve item at position " + index + ", size is " + this.size());
        }
    }

    @Override
    public List<Object> asList() {
        return Arrays.asList(this.item1, this.item2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tuple2)) {
            return false;
        }
        Tuple2 pair = (Tuple2)o;
        if (!Objects.equals(this.item1, pair.item1)) {
            return false;
        }
        return Objects.equals(this.item2, pair.item2);
    }

    public int hashCode() {
        int result = this.item1 != null ? this.item1.hashCode() : 0;
        result = 31 * result + (this.item2 != null ? this.item2.hashCode() : 0);
        return result;
    }

    @Override
    public int size() {
        return 2;
    }

    public String toString() {
        return "Tuple{item1=" + this.item1 + ", item2=" + this.item2 + "}";
    }
}

