/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime.context;

import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;

public final class VertxContextSafetyToggle {
    private static final Object ACCESS_TOGGLE_KEY = new Object();
    public static final String UNRESTRICTED_BY_DEFAULT_PROPERTY = "io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle.UNRESTRICTED_BY_DEFAULT";
    public static final String FULLY_DISABLE_PROPERTY = "io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle.I_HAVE_CHECKED_EVERYTHING";
    private static final boolean UNRESTRICTED_BY_DEFAULT = Boolean.getBoolean("io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle.UNRESTRICTED_BY_DEFAULT");
    private static final boolean FULLY_DISABLED = Boolean.getBoolean("io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle.I_HAVE_CHECKED_EVERYTHING");

    public static void validateContextIfExists(String errorMessageOnVeto, String errorMessageOnDoubt) {
        if (FULLY_DISABLED) {
            return;
        }
        Context context = Vertx.currentContext();
        if (context != null) {
            VertxContextSafetyToggle.checkIsSafe(context, errorMessageOnVeto, errorMessageOnDoubt);
        }
    }

    private static void checkIsSafe(Context context, String errorMessageOnVeto, String errorMessageOnDoubt) {
        if (!VertxContext.isDuplicatedContext(context)) {
            throw new IllegalStateException("Can't get the context safety flag: the current context is not a duplicated context");
        }
        Object safeFlag = context.getLocal(ACCESS_TOGGLE_KEY);
        if (safeFlag == Boolean.TRUE) {
            return;
        }
        if (safeFlag == null && UNRESTRICTED_BY_DEFAULT) {
            return;
        }
        if (safeFlag == null) {
            throw new IllegalStateException(errorMessageOnDoubt);
        }
        throw new IllegalStateException(errorMessageOnVeto);
    }

    public static void setCurrentContextSafe(boolean safe) {
        if (FULLY_DISABLED) {
            return;
        }
        Context context = Vertx.currentContext();
        VertxContextSafetyToggle.setContextSafe(context, safe);
    }

    public static void setContextSafe(Context context, boolean safe) {
        if (FULLY_DISABLED) {
            return;
        }
        if (context == null) {
            throw new IllegalStateException("Can't set the context safety flag: no Vert.x context found");
        }
        if (!VertxContext.isDuplicatedContext(context)) {
            throw new IllegalStateException("Can't set the context safety flag: the current context is not a duplicated context");
        }
        if (safe && context.getLocal(ACCESS_TOGGLE_KEY) == Boolean.TRUE) {
            return;
        }
        context.putLocal(ACCESS_TOGGLE_KEY, safe);
    }
}

