/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.websocket;

import com.google.inject.Injector;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.ContainerDefaultConfigurator;

public class GLSPConfigurator
extends ServerEndpointConfig.Configurator {
    protected ServerEndpointConfig.Configurator containerConfigurator;
    protected final Supplier<Injector> injector;

    public GLSPConfigurator(Supplier<Injector> injector) {
        this.injector = injector;
    }

    ServerEndpointConfig.Configurator getContainerConfigurator() {
        if (this.containerConfigurator == null) {
            ServiceLoader<ServerEndpointConfig.Configurator> loader = ServiceLoader.load(ServerEndpointConfig.Configurator.class);
            this.containerConfigurator = loader.iterator().hasNext() ? loader.iterator().next() : new ContainerDefaultConfigurator();
        }
        return this.containerConfigurator;
    }

    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        return this.getContainerConfigurator().getNegotiatedSubprotocol(supported, requested);
    }

    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        return this.getContainerConfigurator().getNegotiatedExtensions(installed, requested);
    }

    public boolean checkOrigin(String originHeaderValue) {
        return this.getContainerConfigurator().checkOrigin(originHeaderValue);
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        Injector injector = this.injector.get();
        return (T)injector.getInstance(endpointClass);
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
    }
}

