/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.controller;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.client.model.controller.callbacks.CommitCallback;
import org.eclipse.emf.emfstore.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.client.model.observers.CommitObserver;
import org.eclipse.emf.emfstore.server.exceptions.BaseVersionOutdatedException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitController
extends ServerCall<PrimaryVersionSpec> {
    private LogMessage logMessage;
    private CommitCallback callback;

    public CommitController(ProjectSpaceBase projectSpace, LogMessage logMessage, CommitCallback callback, IProgressMonitor monitor) {
        super(projectSpace);
        this.logMessage = logMessage == null ? this.createLogMessage() : logMessage;
        this.callback = callback == null ? CommitCallback.NOCALLBACK : callback;
        this.setProgressMonitor(monitor);
    }

    @Override
    protected PrimaryVersionSpec run() throws EmfStoreException {
        return this.commit(this.logMessage);
    }

    private PrimaryVersionSpec commit(LogMessage logMessage) throws EmfStoreException {
        this.getProgressMonitor().beginTask("Commiting Changes", 100);
        this.getProgressMonitor().worked(1);
        this.getProgressMonitor().subTask("Checking changes");
        if (!this.getProjectSpace().isDirty()) {
            this.callback.noLocalChanges(this.getProjectSpace());
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProjectSpace().cleanCutElements();
        this.getProgressMonitor().subTask("Resolving new version");
        PrimaryVersionSpec resolvedVersion = this.getProjectSpace().resolveVersionSpec(VersionSpec.HEAD_VERSION);
        if (!this.getProjectSpace().getBaseVersion().equals(resolvedVersion) && !this.callback.baseVersionOutOfDate(this.getProjectSpace())) {
            throw new BaseVersionOutdatedException();
        }
        this.getProgressMonitor().worked(10);
        this.getProgressMonitor().subTask("Gathering changes");
        ChangePackage changePackage = this.getProjectSpace().getLocalChangePackage(true);
        changePackage.setLogMessage(logMessage);
        if (changePackage.getOperations().isEmpty()) {
            for (AbstractOperation operation : this.getProjectSpace().getOperations()) {
                this.getProjectSpace().getOperationManager().notifyOperationUndone(operation);
            }
            this.getProjectSpace().getOperations().clear();
            this.getProjectSpace().updateDirtyState();
        }
        ((CommitObserver)WorkspaceManager.getObserverBus().notify(CommitObserver.class)).inspectChanges(this.getProjectSpace(), changePackage);
        this.getProgressMonitor().subTask("Presenting Changes");
        if (!this.callback.inspectChanges(this.getProjectSpace(), changePackage) || this.getProgressMonitor().isCanceled()) {
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProgressMonitor().subTask("Sending changes to server");
        PrimaryVersionSpec newBaseVersion = this.getConnectionManager().createVersion(this.getUsersession().getSessionId(), this.getProjectSpace().getProjectId(), this.getProjectSpace().getBaseVersion(), changePackage, changePackage.getLogMessage());
        this.getProgressMonitor().worked(75);
        this.getProgressMonitor().subTask("Finalizing commit");
        this.getProjectSpace().setBaseVersion(newBaseVersion);
        this.getProjectSpace().getOperations().clear();
        this.getProjectSpace().saveProjectSpaceOnly();
        this.getProjectSpace().getFileTransferManager().uploadQueuedFiles((IProgressMonitor)new NullProgressMonitor());
        ((CommitObserver)WorkspaceManager.getObserverBus().notify(CommitObserver.class)).commitCompleted(this.getProjectSpace(), newBaseVersion);
        this.getProjectSpace().updateDirtyState();
        return newBaseVersion;
    }

    private LogMessage createLogMessage() {
        LogMessage logMessage = VersioningFactory.eINSTANCE.createLogMessage();
        String commiter = "UNKOWN";
        if (this.getProjectSpace().getUsersession() != null && this.getProjectSpace().getUsersession().getACUser() != null && this.getProjectSpace().getUsersession().getACUser().getName() != null) {
            commiter = this.getProjectSpace().getUsersession().getACUser().getName();
        }
        logMessage.setAuthor(commiter);
        logMessage.setClientDate(new Date());
        logMessage.setMessage("");
        return logMessage;
    }
}

