/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.model.versioning.operations.util;

import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AttributeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.DiagramLayoutOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiAttributeMoveOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiAttributeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiAttributeSetOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceMoveOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceSetOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.SingleReferenceOperation;

public final class OperationUtil {
    private OperationUtil() {
    }

    public static boolean isComposite(AbstractOperation operation) {
        return operation instanceof CompositeOperation && ((CompositeOperation)operation).getMainOperation() == null;
    }

    public static boolean isReference(AbstractOperation operation) {
        return OperationUtil.isSingleRef(operation) || OperationUtil.isMultiRef(operation) || OperationUtil.isCompositeRef(operation);
    }

    public static boolean isCompositeRef(AbstractOperation operation) {
        return operation instanceof CompositeOperation && ((CompositeOperation)operation).getMainOperation() != null;
    }

    public static boolean isSingleRef(AbstractOperation operation) {
        return operation instanceof SingleReferenceOperation;
    }

    public static boolean isMultiRef(AbstractOperation operation) {
        return operation instanceof MultiReferenceOperation;
    }

    public static boolean isMultiRefSet(AbstractOperation operation) {
        return operation instanceof MultiReferenceSetOperation;
    }

    public static boolean isMultiMoveRef(AbstractOperation operation) {
        return operation instanceof MultiReferenceMoveOperation;
    }

    public static boolean isAttribute(AbstractOperation operation) {
        return operation instanceof AttributeOperation;
    }

    public static boolean isMultiAtt(AbstractOperation operation) {
        return operation instanceof MultiAttributeOperation;
    }

    public static boolean isMultiAttSet(AbstractOperation operation) {
        return operation instanceof MultiAttributeSetOperation;
    }

    public static boolean isMultiAttMove(AbstractOperation operation) {
        return operation instanceof MultiAttributeMoveOperation;
    }

    public static boolean isDiagramLayout(AbstractOperation operation) {
        return operation instanceof DiagramLayoutOperation;
    }

    public static boolean isCreate(AbstractOperation operation) {
        return OperationUtil.isCreateDelete(operation) && !((CreateDeleteOperation)operation).isDelete();
    }

    public static boolean isDelete(AbstractOperation operation) {
        return OperationUtil.isCreateDelete(operation) && ((CreateDeleteOperation)operation).isDelete();
    }

    public static boolean isCreateDelete(AbstractOperation operation) {
        return operation instanceof CreateDeleteOperation;
    }
}

