/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.internal;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javafx.application.Platform;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.text.ui.internal.WrappedAnnotation;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.TextChangedEvent;
import org.eclipse.fx.ui.controls.styledtext.TextChangingEvent;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationProvider;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotation;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;

public class AnnotationModelSupport {
    private IAnnotationModel annotationModel;
    private StyledTextArea control;
    private Map<Integer, Set<MarkerAnnotation>> annotationCache = new HashMap<Integer, Set<MarkerAnnotation>>();
    private List<Consumer<RangeSet<Integer>>> listener = new ArrayList<Consumer<RangeSet<Integer>>>();

    public AnnotationModelSupport(IAnnotationModel model, StyledTextArea control) {
        this.annotationModel = model;
        this.control = control;
    }

    public void triggerChange(RangeSet<Integer> range) {
        Platform.runLater(() -> this.listener.forEach(l -> l.accept(range)));
    }

    private Set<MarkerAnnotation> findAnnotations(int lineIndex) {
        long now = System.currentTimeMillis();
        HashSet<MarkerAnnotation> result = new HashSet<MarkerAnnotation>();
        Iterator annotationIterator = this.annotationModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            int curLineIndex;
            Annotation a = (Annotation)annotationIterator.next();
            Position position = this.annotationModel.getPosition(a);
            if (position == null || position.offset > this.control.getContent().getCharCount() || (curLineIndex = this.control.getLineAtOffset(position.offset)) != lineIndex) continue;
            int lineBegin = this.control.getOffsetAtLine(curLineIndex);
            int lineLength = this.control.getContent().getLine(curLineIndex).length();
            int lower = position.offset - lineBegin;
            int upper = lower + Math.min(position.length, lineLength);
            Range lineLocalRange = Range.closed((Comparable)Integer.valueOf(lower), (Comparable)Integer.valueOf(upper));
            MarkerAnnotation annotation = new MarkerAnnotation(a, (Range<Integer>)lineLocalRange, this.control.getTabAdvance());
            result.add(annotation);
        }
        return result;
    }

    private Set<MarkerAnnotation> getAnnotations(int lineIndex) {
        Set<MarkerAnnotation> set = this.annotationCache.get(lineIndex);
        if (set == null) {
            set = this.findAnnotations(lineIndex);
            this.annotationCache.put(lineIndex, set);
        }
        return set;
    }

    private void onAnnotationModelChange() {
        this.annotationCache.clear();
        TreeRangeSet range = TreeRangeSet.create();
        range.add(Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        this.triggerChange((RangeSet<Integer>)range);
    }

    public void install() {
        this.annotationModel.addAnnotationModelListener((IAnnotationModelListener)new Listener());
        this.control.getAnnotationProvider().add((Object)new AnnotationModelAnnotationProvider());
        this.control.tabAvanceProperty().addListener((x, o, n) -> this.onAnnotationModelChange());
        StyledTextContent.TextChangeListener textChangeListener = new StyledTextContent.TextChangeListener(){

            public void textSet(TextChangedEvent event) {
                AnnotationModelSupport.this.onAnnotationModelChange();
            }

            public void textChanging(TextChangingEvent event) {
            }

            public void textChanged(TextChangedEvent event) {
                AnnotationModelSupport.this.onAnnotationModelChange();
            }
        };
        this.control.contentProperty().addListener((x, o, n) -> {
            if (o != null) {
                o.removeTextChangeListener(textChangeListener);
            }
            if (n != null) {
                n.addTextChangeListener(textChangeListener);
            }
        });
    }

    class AnnotationModelAnnotationProvider
    implements AnnotationProvider {
        AnnotationModelAnnotationProvider() {
        }

        public Set<? extends org.eclipse.fx.ui.controls.styledtext.model.Annotation> computeAnnotations(int index) {
            return AnnotationModelSupport.this.getAnnotations(index);
        }

        public Subscription registerChangeListener(final Consumer<RangeSet<Integer>> onChange) {
            AnnotationModelSupport.this.listener.add(onChange);
            return new Subscription(){

                public void dispose() {
                    ((AnnotationModelAnnotationProvider)AnnotationModelAnnotationProvider.this).AnnotationModelSupport.this.listener.remove(onChange);
                }
            };
        }
    }

    class Listener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        Listener() {
        }

        public void modelChanged(AnnotationModelEvent event) {
            AnnotationModelSupport.this.onAnnotationModelChange();
        }

        public void modelChanged(IAnnotationModel model) {
        }
    }

    static class MarkerAnnotation
    implements TextAnnotation,
    WrappedAnnotation {
        public final Range<Integer> range;
        public final Annotation annotation;
        public final int tabAdvance;
        private final String nfo;

        public MarkerAnnotation(Annotation annotation, Range<Integer> range, int tabAdvance) {
            this.annotation = annotation;
            this.range = range;
            this.tabAdvance = tabAdvance;
            this.nfo = String.valueOf(annotation.getType()) + annotation.getText();
        }

        @Override
        public Annotation getAnnotation() {
            return this.annotation;
        }

        public Object getModel() {
            return this.annotation;
        }

        public Range<Integer> getRange() {
            return this.range;
        }

        public String toString() {
            return "MarkerAnnotation(" + this.range + ", " + this.nfo + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nfo == null ? 0 : this.nfo.hashCode());
            result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
            result = 31 * result + this.tabAdvance;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MarkerAnnotation other = (MarkerAnnotation)obj;
            if (this.nfo == null ? other.nfo != null : !this.nfo.equals(other.nfo)) {
                return false;
            }
            if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
                return false;
            }
            return this.tabAdvance == other.tabAdvance;
        }
    }
}

