/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;

public class XtextVersion {
    private final String version;

    public XtextVersion(String version) {
        this.version = version;
    }

    public static XtextVersion getCurrent() {
        String versionFromManifest = XtextVersion.readVersionFromManifest();
        return new XtextVersion(versionFromManifest != null ? versionFromManifest : "unknown");
    }

    public String getXtextGradlePluginVersion() {
        return "3.0.2";
    }

    public String getMweVersion() {
        return "2.13.0";
    }

    public String getMweBuildNumber() {
        return "";
    }

    public String getAntlrGeneratorVersion() {
        return "2.1.1";
    }

    public String getXtendGradlePluginVersion() {
        return this.getXtextGradlePluginVersion();
    }

    public String getXtendAndroidGradlePluginVersion() {
        return this.getXtendGradlePluginVersion();
    }

    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public boolean isStable() {
        return !this.isSnapshot() && !this.version.matches("\\d+\\.\\d+(\\.\\d+)+");
    }

    public String toString() {
        return this.version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readVersionFromManifest() {
        URL baseURL = null;
        try {
            baseURL = Plugin.INSTANCE.getBaseURL();
        }
        catch (Exception e) {
            return null;
        }
        try (InputStream is = new URL(baseURL + "META-INF/MANIFEST.MF").openStream();){
            Manifest manifest = new Manifest(is);
            String version = manifest.getMainAttributes().getValue("Maven-Version");
            if ("unspecified".equals(version)) {
                version = manifest.getMainAttributes().getValue("Bundle-Version");
                if (version.endsWith(".qualifier")) {
                    String string = version.replace(".qualifier", "-SNAPSHOT");
                    return string;
                }
                String string = version.substring(0, version.lastIndexOf("."));
                return string;
            }
            String string = version;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return 31 + (this.version == null ? 0 : this.version.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XtextVersion other = (XtextVersion)obj;
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getVersion() {
        return this.version;
    }

    private static class Plugin
    extends EMFPlugin {
        public static final Plugin INSTANCE = new Plugin();

        private Plugin() {
            super(new ResourceLocator[0]);
        }

        public ResourceLocator getPluginResourceLocator() {
            return null;
        }
    }
}

