/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ColorMatrixType implements Enumerator
{
    MATRIX(0, "matrix", "matrix"),
    SATURATE(1, "saturate", "saturate"),
    HUE_ROTATE(2, "hueRotate", "hueRotate"),
    LUMINANCE_TO_ALPHA(3, "luminanceToAlpha", "luminanceToAlpha");

    public static final int MATRIX_VALUE = 0;
    public static final int SATURATE_VALUE = 1;
    public static final int HUE_ROTATE_VALUE = 2;
    public static final int LUMINANCE_TO_ALPHA_VALUE = 3;
    private static final ColorMatrixType[] VALUES_ARRAY;
    public static final List<ColorMatrixType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ColorMatrixType[]{MATRIX, SATURATE, HUE_ROTATE, LUMINANCE_TO_ALPHA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ColorMatrixType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ColorMatrixType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ColorMatrixType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ColorMatrixType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ColorMatrixType get(int value) {
        switch (value) {
            case 0: {
                return MATRIX;
            }
            case 1: {
                return SATURATE;
            }
            case 2: {
                return HUE_ROTATE;
            }
            case 3: {
                return LUMINANCE_TO_ALPHA;
            }
        }
        return null;
    }

    private ColorMatrixType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

