/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.internal.container.Capabilities;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

public class ModuleRequirement
implements BundleRequirement {
    private final String namespace;
    private final Map<String, String> directives;
    private final Map<String, Object> attributes;
    private final ModuleRevision revision;
    private static final String PACKAGENAME_FILTER_COMPONENT = "osgi.wiring.package=";

    ModuleRequirement(String namespace, Map<String, String> directives, Map<String, ?> attributes, ModuleRevision revision) {
        this.namespace = namespace;
        this.directives = ModuleRevisionBuilder.unmodifiableMap(directives);
        this.attributes = ModuleRevisionBuilder.unmodifiableMap(attributes);
        this.revision = revision;
    }

    @Override
    public ModuleRevision getRevision() {
        return this.revision;
    }

    @Override
    public boolean matches(BundleCapability capability) {
        if (!this.namespace.equals(capability.getNamespace())) {
            return false;
        }
        String filterSpec = this.directives.get("filter");
        FilterImpl f = null;
        if (filterSpec != null) {
            try {
                f = FilterImpl.newInstance(filterSpec);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                return false;
            }
        }
        boolean matchMandatory = "osgi.wiring.package".equals(this.namespace) || "osgi.wiring.bundle".equals(this.namespace) || "osgi.wiring.host".equals(this.namespace);
        return Capabilities.matches(f, capability, matchMandatory);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public ModuleRevision getResource() {
        return this.revision;
    }

    public String toString() {
        return String.valueOf(this.namespace) + ModuleRevision.toString(this.attributes, false) + ModuleRevision.toString(this.directives, true);
    }

    DynamicModuleRequirement getDynamicPackageRequirement(ModuleRevision host, String dynamicPkgName) {
        if (!"osgi.wiring.package".equals(this.namespace)) {
            return null;
        }
        if (!"dynamic".equals(this.directives.get("resolution"))) {
            return null;
        }
        String dynamicFilter = this.directives.get("filter");
        int packageNameBegin = dynamicFilter.indexOf(PACKAGENAME_FILTER_COMPONENT);
        if (packageNameBegin == -1) {
            return null;
        }
        int packageNameEnd = dynamicFilter.indexOf(41, packageNameBegin += PACKAGENAME_FILTER_COMPONENT.length());
        if (packageNameEnd == -1) {
            return null;
        }
        String filterPackageName = dynamicFilter.substring(packageNameBegin, packageNameEnd);
        String specificPackageFilter = null;
        if ("*".equals(filterPackageName)) {
            specificPackageFilter = dynamicFilter.replace(PACKAGENAME_FILTER_COMPONENT + filterPackageName, PACKAGENAME_FILTER_COMPONENT + dynamicPkgName);
        } else if (filterPackageName.endsWith(".*")) {
            if (dynamicPkgName.startsWith(filterPackageName.substring(0, filterPackageName.length() - 1))) {
                specificPackageFilter = dynamicFilter.replace(PACKAGENAME_FILTER_COMPONENT + filterPackageName, PACKAGENAME_FILTER_COMPONENT + dynamicPkgName);
            }
        } else if (dynamicPkgName.equals(filterPackageName)) {
            specificPackageFilter = dynamicFilter;
        }
        if (specificPackageFilter != null) {
            HashMap<String, String> dynamicDirectives = new HashMap<String, String>(this.directives);
            dynamicDirectives.put("filter", specificPackageFilter);
            return new DynamicModuleRequirement(host, dynamicDirectives);
        }
        return null;
    }

    class DynamicModuleRequirement
    extends ModuleRequirement {
        DynamicModuleRequirement(ModuleRevision host, Map<String, String> directives) {
            super(ModuleRequirement.this.getNamespace(), directives, ModuleRequirement.this.getAttributes(), host);
        }

        ModuleRequirement getOriginal() {
            return ModuleRequirement.this;
        }
    }
}

