/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.fx.core.URLDynamicDataStreamHandler;
import org.eclipse.fx.core.URLStreamHandler;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class DynamicDataStreamHandler
implements URLStreamHandler {
    private Map<String, URLDynamicDataStreamHandler> map = new HashMap<String, URLDynamicDataStreamHandler>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void registerURLDynamicDataStreamHandler(URLDynamicDataStreamHandler handler) {
        this.map.put(handler.getId(), handler);
    }

    public void unregisterURLDynamicDataStreamHandler(URLDynamicDataStreamHandler handler) {
        this.map.remove(handler.getId(), handler);
    }

    @Override
    public @NonNull String getProtocol() {
        return "dyndata";
    }

    @Override
    public @NonNull InputStream createStream(@NonNull URL url) throws IOException {
        if (URLDynamicDataStreamHandler.isValidDynamicDataStreamURL(url)) {
            InputStream inStream = Stream.of(url.getQuery().split("&")).filter(e -> e.startsWith("efx_DynamicDataHandlerId")).findFirst().map(e -> e.split("=")[1]).map(id -> this.map.get(id)).map(h -> h.createDataStream(url)).orElse(null);
            if (inStream == null) {
                throw new IOException("Could not create input stream for URL '" + url + "'");
            }
            return inStream;
        }
        InputStream inStream = new URL(url.toExternalForm().substring("dyndata".length() + 1)).openStream();
        if (inStream == null) {
            throw new IOException("Could not create input stream for URL '" + url + "'");
        }
        return inStream;
    }
}

