/*
 *******************************************************************************
 * Copyright (C) 2012-2012, Google, International Business Machines Corporation and
 * others. All Rights Reserved.
 *******************************************************************************
 */
package com.ibm.icu.text;

class ListFormatterData {
    static void load() {
        ListFormatter.add("af", "{0} en {1}", "{0}, {1}", "{0}, {1}", "{0} en {1}");
        ListFormatter.add("am", "{0} እና {1}", "{0}, {1}", "{0}, {1}", "{0}, እና {1}");
        ListFormatter.add("ar", "{0} و {1}", "{0}، {1}", "{0}، {1}", "{0}، و {1}");
        ListFormatter.add("bg", "{0} и {1}", "{0}, {1}", "{0}, {1}", "{0} и {1}");
        ListFormatter.add("bn", "{0} এবং {1}", "{0}, {1}", "{0}, {1}", "{0}, এবং {1}");
        ListFormatter.add("bs", "{0} i {1}", "{0}, {1}", "{0}, {1}", "{0} i {1}");
        ListFormatter.add("ca", "{0} i {1}", "{0}, {1}", "{0}, {1}", "{0} i {1}");
        ListFormatter.add("cs", "{0} a {1}", "{0}, {1}", "{0}, {1}", "{0} a {1}");
        ListFormatter.add("da", "{0} og {1}", "{0}, {1}", "{0}, {1}", "{0} og {1}");
        ListFormatter.add("de", "{0} und {1}", "{0}, {1}", "{0}, {1}", "{0} und {1}");
        ListFormatter.add("ee", "{0} kple {1}", "{0}, {1}", "{0}, {1}", "{0}, kple {1}");
        ListFormatter.add("el", "{0} και {1}", "{0}, {1}", "{0}, {1}", "{0} και {1}");
        ListFormatter.add("en", "{0} and {1}", "{0}, {1}", "{0}, {1}", "{0}, and {1}");
        ListFormatter.add("es", "{0} y {1}", "{0}, {1}", "{0}, {1}", "{0} y {1}");
        ListFormatter.add("et", "{0} ja {1}", "{0}, {1}", "{0}, {1}", "{0} ja {1}");
        ListFormatter.add("eu", "{0} eta {1}", "{0}, {1}", "{0}, {1}", "{0} eta {1}");
        ListFormatter.add("fa", "{0} و {1}", "{0}،‏ {1}", "{0}،‏ {1}", "{0}، و {1}");
        ListFormatter.add("fi", "{0} ja {1}", "{0}, {1}", "{0}, {1}", "{0} ja {1}");
        ListFormatter.add("fil", "{0} at {1}", "{0}, {1}", "{0}, {1}", "{0} at {1}");
        ListFormatter.add("fo", "{0} og {1}", "{0}, {1}", "{0}, {1}", "{0} og {1}");
        ListFormatter.add("fr", "{0} et {1}", "{0}, {1}", "{0}, {1}", "{0} et {1}");
        ListFormatter.add("fur", "{0} e {1}", "{0}, {1}", "{0}, {1}", "{0} e {1}");
        ListFormatter.add("gd", "{0} agus {1}", "{0}, {1}", "{0}, {1}", "{0}, agus {1}");
        ListFormatter.add("gl", "{0} e {1}", "{0}, {1}", "{0}, {1}", "{0} e {1}");
        ListFormatter.add("gsw", "{0} und {1}", "{0}, {1}", "{0}, {1}", "{0} und {1}");
        ListFormatter.add("gu", "{0} અને {1}", "{0}, {1}", "{0}, {1}", "{0} અને {1}");
        ListFormatter.add("he", "{0} ו-{1}", "{0}, {1}", "{0}, {1}", "{0} ו-{1}");
        ListFormatter.add("hi", "{0} और {1}", "{0}, {1}", "{0}, {1}", "{0}, और {1}");
        ListFormatter.add("hr", "{0} i {1}", "{0}, {1}", "{0}, {1}", "{0} i {1}");
        ListFormatter.add("hu", "{0} és {1}", "{0}, {1}", "{0}, {1}", "{0} és {1}");
        ListFormatter.add("id", "{0} dan {1}", "{0}, {1}", "{0}, {1}", "{0}, dan {1}");
        ListFormatter.add("is", "{0} og {1}", "{0}, {1}", "{0}, {1}", "{0} og {1}");
        ListFormatter.add("it", "{0} e {1}", "{0}, {1}", "{0}, {1}", "{0}, e {1}");
        ListFormatter.add("ja", "{0}、{1}", "{0}、{1}", "{0}、{1}", "{0}、{1}");
        ListFormatter.add("ka", "{0} და {1}", "{0}, {1}", "{0}, {1}", "{0} და {1}");
        ListFormatter.add("kea", "{0} y {1}", "{0}, {1}", "{0}, {1}", "{0} y {1}");
        ListFormatter.add("kl", "{0} aamma {1}", "{0} aamma {1}", "{0}, {1}", "{0}, {1}");
        ListFormatter.add("kn", "{0} ಮತ್ತು {1}", "{0}, {1}", "{0}, {1}", "{0}, ಮತ್ತು {1}");
        ListFormatter.add("ko", "{0} 및 {1}", "{0}, {1}", "{0}, {1}", "{0} 및 {1}");
        ListFormatter.add("ksh", "{0} un {1}", "{0}, {1}", "{0}, {1}", "{0} un {1}");
        ListFormatter.add("lt", "{0} ir {1}", "{0}, {1}", "{0}, {1}", "{0} ir {1}");
        ListFormatter.add("lv", "{0} un {1}", "{0}, {1}", "{0}, {1}", "{0} un {1}");
        ListFormatter.add("ml", "{0} കൂടാതെ {1}", "{0}, {1}", "{0}, {1}", "{0}, {1} എന്നിവ");
        ListFormatter.add("mr", "{0} आणि {1}", "{0}, {1}", "{0}, {1}", "{0} आणि {1}");
        ListFormatter.add("ms", "{0} dan {1}", "{0}, {1}", "{0}, {1}", "{0}, dan {1}");
        ListFormatter.add("nb", "{0} og {1}", "{0}, {1}", "{0}, {1}", "{0} og {1}");
        ListFormatter.add("nl", "{0} en {1}", "{0}, {1}", "{0}, {1}", "{0} en {1}");
        ListFormatter.add("nn", "{0} og {1}", "{0}, {1}", "{0}, {1}", "{0} og {1}");
        ListFormatter.add("pl", "{0} i {1}", "{0}; {1}", "{0}; {1}", "{0} i {1}");
        ListFormatter.add("pt", "{0} e {1}", "{0}, {1}", "{0}, {1}", "{0} e {1}");
        ListFormatter.add("ro", "{0} şi {1}", "{0}, {1}", "{0}, {1}", "{0} şi {1}");
        ListFormatter.add("", "{0}, {1}", "{0}, {1}", "{0}, {1}", "{0}, {1}"); // root
        ListFormatter.add("ru", "{0} и {1}", "{0}, {1}", "{0}, {1}", "{0} и {1}");
        ListFormatter.add("se", "{0} ja {1}", "{0}, {1}", "{0}, {1}", "{0} ja {1}");
        ListFormatter.add("sk", "{0} a {1}", "{0}, {1}", "{0}, {1}", "{0} a {1}");
        ListFormatter.add("sl", "{0} in {1}", "{0}, {1}", "{0}, {1}", "{0} in {1}");
        ListFormatter.add("sr", "{0} и {1}", "{0}, {1}", "{0}, {1}", "{0} и {1}");
        ListFormatter.add("sr_Cyrl", "{0} и {1}", "{0}, {1}", "{0}, {1}", "{0} и {1}");
        ListFormatter.add("sr_Latn", "{0} i {1}", "{0}, {1}", "{0}, {1}", "{0} i {1}");
        ListFormatter.add("sv", "{0} och {1}", "{0}, {1}", "{0}, {1}", "{0} och {1}");
        ListFormatter.add("sw", "{0} na {1}", "{0}, {1}", "{0}, {1}", "{0}, na {1}");
        ListFormatter.add("ta", "{0} மற்றும் {1}", "{0}, {1}", "{0}, {1}", "{0} மற்றும் {1}");
        ListFormatter.add("te", "{0} మరియు {1}", "{0}, {1}", "{0}, {1}", "{0} మరియు {1}");
        ListFormatter.add("th", "{0}และ{1}", "{0} {1}", "{0} {1}", "{0} และ{1}");
        ListFormatter.add("tr", "{0} ve {1}", "{0}, {1}", "{0}, {1}", "{0} ve {1}");
        ListFormatter.add("uk", "{0} та {1}", "{0}, {1}", "{0}, {1}", "{0} та {1}");
        ListFormatter.add("ur", "{0} اور {1}", "{0}، {1}", "{0}، {1}", "{0}، اور {1}");
        ListFormatter.add("vi", "{0} và {1}", "{0}, {1}", "{0}, {1}", "{0} và {1}");
        ListFormatter.add("wae", "{0} und {1}", "{0}, {1}", "{0}, {1}", "{0} und {1}");
        ListFormatter.add("zh", "{0}和{1}", "{0}、{1}", "{0}、{1}", "{0}和{1}");
        ListFormatter.add("zh", "{0}和{1}", "{0}、{1}", "{0}、{1}", "{0}和{1}");
        ListFormatter.add("zu", "I-{0} ne-{1}", "{0}, {1}", "{0}, {1}", "{0}, no-{1}");
    }
}
